/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.encode;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.processor.encode.Mirrors;

public class ImplMirror
implements Mirrors.Impl {
    public static final String QUALIFIED_NAME = "org.immutables.encode.Encoding.Impl";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.processor.encode.Mirrors.Impl";
    private final AnnotationMirror annotationMirror;
    private final boolean virtual;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Impl";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static Optional<ImplMirror> find(Element element) {
        return ImplMirror.find(element.getAnnotationMirrors());
    }

    public static Optional<ImplMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return Optional.of((Object)new ImplMirror(annotationMirror));
        }
        return Optional.absent();
    }

    public static ImmutableList<ImplMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Preconditions.checkState((boolean)element.getQualifiedName().contentEquals(QUALIFIED_NAME), (Object)"Supplied mirrors should all be of this annotation type");
            builder.add((Object)new ImplMirror(annotationMirror));
        }
        return builder.build();
    }

    public static ImplMirror from(TypeElement element) {
        return new ImplMirror(element);
    }

    public static Optional<ImplMirror> from(AnnotationMirror mirror) {
        return ImplMirror.find(Collections.singleton(mirror));
    }

    private ImplMirror(TypeElement defaultAnnotationElement) {
        Preconditions.checkArgument((defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME) ? 1 : 0) != 0);
        this.annotationMirror = null;
        boolean virtual = false;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"virtual".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Impl");
            }
            VirtualExtractor virtualExtractor$ = new VirtualExtractor();
            annotationValue$.accept(virtualExtractor$, null);
            virtual = virtualExtractor$.get();
        }
        this.virtual = virtual;
    }

    private ImplMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        boolean virtual = false;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"virtual".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'virtual' attribute of @Impl");
            }
            VirtualExtractor virtualExtractor$ = new VirtualExtractor();
            annotationValue$.accept(virtualExtractor$, null);
            virtual = virtualExtractor$.get();
        }
        this.virtual = virtual;
    }

    @Override
    public boolean virtual() {
        return this.virtual;
    }

    public AnnotationMirror getAnnotationMirror() {
        Preconditions.checkState((this.annotationMirror != null ? 1 : 0) != 0, (Object)"this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Mirrors.Impl.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        return h += 127 * "virtual".hashCode() ^ Booleans.hashCode((boolean)this.virtual);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ImplMirror) {
            ImplMirror otherMirror = (ImplMirror)other;
            return this.virtual == otherMirror.virtual;
        }
        return false;
    }

    @Override
    public String toString() {
        return "ImplMirror:" + this.annotationMirror;
    }

    private static class VirtualExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private VirtualExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'virtual' in @org.immutables.encode.Encoding.Impl");
        }
    }
}

