/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingAssociationInverseSideCollector;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.loading.impl.PojoLoadingPlan;
import org.hibernate.search.mapper.pojo.loading.impl.PojoMultiLoaderLoadingPlan;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorRootContext;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorSessionContext;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.impl.AbstractPojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoContainedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexingPlanStrategy;
import org.hibernate.search.mapper.pojo.work.impl.PojoLoadingPlanProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexingPlanImpl
implements PojoIndexingPlan,
PojoLoadingPlanProvider,
PojoReindexingCollector,
PojoReindexingAssociationInverseSideCollector,
PojoIndexingProcessorRootContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoWorkTypeContextProvider typeContextProvider;
    private final PojoWorkSessionContext sessionContext;
    private final PojoRuntimeIntrospector introspector;
    private final PojoIndexingPlanStrategy strategy;
    protected final Map<PojoRawTypeIdentifier<?>, PojoIndexedTypeIndexingPlan<?, ?>> indexedTypeDelegates = new LinkedHashMap();
    protected final Map<PojoRawTypeIdentifier<?>, PojoContainedTypeIndexingPlan<?, ?>> containedTypeDelegates = new LinkedHashMap();
    private boolean isProcessing = false;
    private PojoLoadingPlan<Object> loadingPlan = null;

    public PojoIndexingPlanImpl(PojoWorkTypeContextProvider typeContextProvider, PojoWorkSessionContext sessionContext, PojoIndexingPlanStrategy strategy) {
        this.typeContextProvider = typeContextProvider;
        this.sessionContext = sessionContext;
        this.introspector = sessionContext.runtimeIntrospector();
        this.strategy = strategy;
    }

    @Override
    @Deprecated
    public void add(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        PojoTypeIndexingPlan delegate = this.typeIfIncludedOrNull((PojoRawTypeIdentifier)typeIdentifier);
        if (delegate == null) {
            return;
        }
        ((AbstractPojoTypeIndexingPlan)delegate).add(providedId, providedRoutes, entity);
    }

    @Override
    @Deprecated
    public void addOrUpdate(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity, boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPaths) {
        PojoTypeIndexingPlan delegate = this.typeIfIncludedOrNull((PojoRawTypeIdentifier)typeIdentifier);
        if (delegate == null) {
            return;
        }
        ((AbstractPojoTypeIndexingPlan)delegate).addOrUpdate(providedId, providedRoutes, entity, forceSelfDirty, forceContainingDirty, dirtyPaths);
    }

    @Override
    @Deprecated
    public void delete(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        PojoTypeIndexingPlan delegate = this.typeIfIncludedOrNull((PojoRawTypeIdentifier)typeIdentifier);
        if (delegate == null) {
            return;
        }
        ((AbstractPojoTypeIndexingPlan)delegate).delete(providedId, providedRoutes, entity);
    }

    @Override
    @Deprecated
    public void addOrUpdateOrDelete(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, DocumentRoutesDescriptor providedRoutes, boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPaths) {
        PojoTypeIndexingPlan delegate = this.typeIfIncludedOrNull((PojoRawTypeIdentifier)typeIdentifier);
        if (delegate == null) {
            return;
        }
        ((AbstractPojoTypeIndexingPlan)delegate).addOrUpdateOrDelete(providedId, providedRoutes, forceSelfDirty, forceContainingDirty, dirtyPaths);
    }

    @Override
    @Deprecated
    public void updateAssociationInverseSide(PojoRawTypeIdentifier<?> typeIdentifier, BitSet dirtyAssociationPaths, Object[] oldState, Object[] newState) {
        PojoTypeIndexingPlan delegate = this.typeIfIncludedOrNull((PojoRawTypeIdentifier)typeIdentifier);
        if (delegate == null) {
            return;
        }
        ((AbstractPojoTypeIndexingPlan)delegate).updateAssociationInverseSide(dirtyAssociationPaths, oldState, newState);
    }

    @Override
    public AbstractPojoTypeIndexingPlan<?, ?, ?> typeIfIncludedOrNull(PojoRawTypeIdentifier<?> typeIdentifier) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.typeOrNull(typeIdentifier);
        if (delegate == null && this.sessionContext.configuredIndexingPlanFilter().isIncluded(typeIdentifier)) {
            delegate = this.createDelegate(typeIdentifier);
        }
        return delegate;
    }

    private AbstractPojoTypeIndexingPlan<?, ?, ?> typeOrNull(PojoRawTypeIdentifier<?> typeIdentifier) {
        AbstractPojoTypeIndexingPlan delegate = this.indexedTypeDelegates.get(typeIdentifier);
        if (delegate == null) {
            delegate = this.containedTypeDelegates.get(typeIdentifier);
        }
        return delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        if (this.isProcessing) {
            throw log.recursiveIndexingPlanProcess();
        }
        this.isProcessing = true;
        try {
            for (PojoContainedTypeIndexingPlan<?, ?> pojoContainedTypeIndexingPlan : this.containedTypeDelegates.values()) {
                pojoContainedTypeIndexingPlan.planLoading();
            }
            for (PojoIndexedTypeIndexingPlan pojoIndexedTypeIndexingPlan : this.indexedTypeDelegates.values()) {
                pojoIndexedTypeIndexingPlan.planLoading();
            }
            if (this.loadingPlan != null) {
                this.loadingPlan.loadBlocking(null);
            }
            boolean shouldResolveDirtyForDeleteOnly = this.strategy.shouldResolveDirtyForDeleteOnly();
            for (PojoContainedTypeIndexingPlan<?, ?> pojoContainedTypeIndexingPlan : this.containedTypeDelegates.values()) {
                pojoContainedTypeIndexingPlan.resolveDirty(shouldResolveDirtyForDeleteOnly);
            }
            ArrayList arrayList = new ArrayList(this.indexedTypeDelegates.values());
            for (PojoIndexedTypeIndexingPlan pojoIndexedTypeIndexingPlan : arrayList) {
                pojoIndexedTypeIndexingPlan.resolveDirty(shouldResolveDirtyForDeleteOnly);
            }
            for (PojoContainedTypeIndexingPlan<?, ?> pojoContainedTypeIndexingPlan : this.containedTypeDelegates.values()) {
                pojoContainedTypeIndexingPlan.process(this);
            }
            for (PojoIndexedTypeIndexingPlan<?, ?> pojoIndexedTypeIndexingPlan : this.indexedTypeDelegates.values()) {
                pojoIndexedTypeIndexingPlan.process(this);
            }
        }
        finally {
            this.isProcessing = false;
            this.loadingPlan = null;
            this.clearStates();
        }
    }

    @Override
    public CompletableFuture<MultiEntityOperationExecutionReport> executeAndReport(OperationSubmitter operationSubmitter) {
        try {
            this.process();
            CompletableFuture<MultiEntityOperationExecutionReport> completableFuture = this.strategy.doExecuteAndReport(this.indexedTypeDelegates.values(), this, operationSubmitter);
            return completableFuture;
        }
        finally {
            this.indexedTypeDelegates.clear();
        }
    }

    @Override
    public void discard() {
        try {
            this.strategy.doDiscard(this.indexedTypeDelegates.values());
        }
        finally {
            this.indexedTypeDelegates.clear();
            this.containedTypeDelegates.clear();
        }
    }

    @Override
    public void discardNotProcessed() {
        this.clearStates();
    }

    private void clearStates() {
        for (PojoIndexedTypeIndexingPlan<?, ?> pojoIndexedTypeIndexingPlan : this.indexedTypeDelegates.values()) {
            pojoIndexedTypeIndexingPlan.clearStates();
        }
        for (PojoContainedTypeIndexingPlan pojoContainedTypeIndexingPlan : this.containedTypeDelegates.values()) {
            pojoContainedTypeIndexingPlan.clearStates();
        }
    }

    @Override
    public void updateBecauseOfContained(PojoRawTypeIdentifier<?> typeIdentifier, Object containingEntity) {
        PojoTypeIndexingPlan delegate = this.typeIfIncludedOrNull((PojoRawTypeIdentifier)typeIdentifier);
        if (delegate == null) {
            return;
        }
        ((AbstractPojoTypeIndexingPlan)delegate).updateBecauseOfContained(containingEntity);
    }

    @Override
    public void updateBecauseOfContainedAssociation(PojoRawTypeIdentifier<?> typeIdentifier, Object containingEntity, int dirtyAssociationPathOrdinal) {
        PojoTypeIndexingPlan delegate = this.typeIfIncludedOrNull((PojoRawTypeIdentifier)typeIdentifier);
        if (delegate == null) {
            return;
        }
        ((AbstractPojoTypeIndexingPlan)delegate).updateBecauseOfContainedAssociation(containingEntity, dirtyAssociationPathOrdinal);
    }

    @Override
    public PojoIndexingProcessorSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    public boolean isDeleted(Object unproxiedObject) {
        PojoRawTypeIdentifier<Object> typeIdentifier = this.introspector.detectEntityType(unproxiedObject);
        if (typeIdentifier == null) {
            return false;
        }
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.typeOrNull(typeIdentifier);
        if (delegate == null) {
            return false;
        }
        return delegate.isDeleted(unproxiedObject);
    }

    private AbstractPojoTypeIndexingPlan<?, ?, ?> createDelegate(PojoRawTypeIdentifier<?> typeIdentifier) {
        if (!this.sessionContext.configuredIndexingPlanFilter().isIncluded(typeIdentifier)) {
            throw log.attemptToCreateIndexingPlanForExcludedType(typeIdentifier);
        }
        PojoWorkTypeContext<?, ?> typeContext = this.typeContextProvider.forExactType(typeIdentifier);
        Optional<PojoWorkIndexedTypeContext<?, ?>> indexedTypeContextOptional = typeContext.asIndexed();
        if (indexedTypeContextOptional.isPresent()) {
            PojoWorkIndexedTypeContext<?, ?> indexedTypeContext = indexedTypeContextOptional.get();
            PojoIndexedTypeIndexingPlan<?, ?> delegate = this.createDelegate(indexedTypeContext);
            this.indexedTypeDelegates.put(typeIdentifier, delegate);
            return delegate;
        }
        PojoWorkContainedTypeContext<?, ?> containedTypeContext = typeContext.asContained().orElseThrow(() -> new AssertionFailure("Type is neither indexed nor contained"));
        PojoContainedTypeIndexingPlan<?, ?> delegate = this.createDelegate(containedTypeContext);
        this.containedTypeDelegates.put(typeIdentifier, delegate);
        return delegate;
    }

    @Override
    public PojoLoadingPlan<Object> loadingPlan() {
        if (this.loadingPlan == null) {
            this.loadingPlan = new PojoMultiLoaderLoadingPlan<Object>(this.sessionContext.defaultLoadingContext());
        }
        return this.loadingPlan;
    }

    private <I, E> PojoIndexedTypeIndexingPlan<I, E> createDelegate(PojoWorkIndexedTypeContext<I, E> typeContext) {
        return this.strategy.createIndexedDelegate(typeContext, this.sessionContext, this);
    }

    private PojoContainedTypeIndexingPlan<?, ?> createDelegate(PojoWorkContainedTypeContext<?, ?> typeContext) {
        return this.strategy.createDelegate(typeContext, this.sessionContext, this);
    }
}

