/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.spi;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class SingleValuedProjectionAccumulator<E, V>
implements ProjectionAccumulator<E, V, Object, V> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    static final ProjectionAccumulator.Provider PROVIDER = new ProjectionAccumulator.Provider(){
        private final SingleValuedProjectionAccumulator instance = new SingleValuedProjectionAccumulator();

        public ProjectionAccumulator get() {
            return this.instance;
        }

        @Override
        public boolean isSingleValued() {
            return true;
        }
    };

    private SingleValuedProjectionAccumulator() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public E createInitial() {
        return null;
    }

    @Override
    public E accumulate(Object accumulated, E value) {
        if (accumulated != null) {
            throw log.unexpectedMultiValuedField(accumulated, value);
        }
        return value;
    }

    @Override
    public int size(Object accumulated) {
        return accumulated == null ? 0 : 1;
    }

    @Override
    public E get(Object accumulated, int index) {
        return (E)accumulated;
    }

    @Override
    public Object transform(Object accumulated, int index, V transformed) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("Invalid index passed to " + String.valueOf(this) + ": " + index);
        }
        return transformed;
    }

    @Override
    public Object transformAll(Object accumulated, ProjectionConverter<? super E, ? extends V> converter, FromDocumentValueConvertContext context) {
        return converter.fromDocumentValue(accumulated, context);
    }

    @Override
    public V finish(Object accumulated) {
        return (V)accumulated;
    }
}

