/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.classpath.spi;

import java.io.InputStream;
import java.net.URL;
import org.hibernate.search.engine.environment.classpath.spi.AggregatedClassLoader;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.util.common.annotation.impl.SuppressForbiddenApis;

public final class DefaultResourceResolver
implements ResourceResolver {
    private final AggregatedClassLoader aggregatedClassLoader;

    public static ResourceResolver create(AggregatedClassLoader aggregatedClassLoader) {
        return new DefaultResourceResolver(aggregatedClassLoader);
    }

    private DefaultResourceResolver(AggregatedClassLoader aggregatedClassLoader) {
        this.aggregatedClassLoader = aggregatedClassLoader;
    }

    @Override
    @SuppressForbiddenApis(reason="URL constructors are deprecated in JDK 20+ in favor of using URI.toURL(), but we want to preserve backward compatibility for now (see below).")
    public InputStream locateResourceStream(String name) {
        String stripped;
        try {
            InputStream stream = this.aggregatedClassLoader.getResourceAsStream(name);
            if (stream != null) {
                return stream;
            }
        }
        catch (Exception stream) {
            // empty catch block
        }
        String string = stripped = name.startsWith("/") ? name.substring(1) : null;
        if (stripped != null) {
            try {
                InputStream resourceStream = new URL(stripped).openStream();
                return resourceStream;
            }
            catch (Exception resourceStream) {
                try {
                    InputStream stream = this.aggregatedClassLoader.getResourceAsStream(stripped);
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

