/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.AggregationFunction;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;

public class AggregationFunctionCollector<R extends AggregationFunction<?>>
extends SimpleCollector {
    private final LongMultiValuesSource valueSource;
    private final AggregationFunction<R> aggregationFunction;
    private LongMultiValues values;

    public AggregationFunctionCollector(LongMultiValuesSource valueSource, AggregationFunction<R> aggregationFunction) {
        this.valueSource = valueSource;
        this.aggregationFunction = aggregationFunction;
    }

    public void merge(AggregationFunctionCollector<R> sibling) {
        this.aggregationFunction.merge(sibling.aggregationFunction);
    }

    public Long result() {
        return this.aggregationFunction.result();
    }

    public void collect(int doc) throws IOException {
        if (this.values.advanceExact(doc)) {
            while (this.values.hasNextValue()) {
                long value = this.values.nextValue();
                this.aggregationFunction.apply(value);
                if (this.aggregationFunction.acceptMultipleValues()) continue;
                break;
            }
        }
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.values = this.valueSource.getValues(context);
    }

    public void finish() throws IOException {
        this.values = null;
    }
}

