/**
 *
 *   Copyright 2014 sourceforge.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.gwtopenmaps.openlayers.client.handler;

import org.gwtopenmaps.openlayers.client.util.JSObject;

/**
 *
 * @author rhs - Roland.Schweitzer@noaa.gov
 *
 * @author Giuseppe La Scaleia - CNR IMAA geoSDI Group
 * @email giuseppe.lascaleia@geosdi.org
 *
 */
public class RegularPolygonHandler extends Handler {

    public static RegularPolygonHandler narrowToRegularPolygonHandler(
            JSObject element) {
        return (element == null) ? null : new RegularPolygonHandler(element);
    }

    protected RegularPolygonHandler(JSObject element) {
        super(element);
    }

    public RegularPolygonHandler() {
        this(RegularPolygonHandlerImpl.create());
    }

    public void setOptions(RegularPolygonHandlerOptions options) {
        RegularPolygonHandlerImpl.setOptions(getJSObject(),
                options.getJSObject());
    }

}
