/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.requests.readers;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WCS;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.requests.DescribeRequest;

public class DescribeKvpReader
extends KvpRequestReader {
    public DescribeKvpReader(Map kvPairs, WCS wcs) {
        super(kvPairs, (Service)wcs);
    }

    public Request getRequest(HttpServletRequest request) throws WcsException {
        String requestType;
        String version;
        String service;
        DescribeRequest currentRequest = new DescribeRequest((WCS)this.serviceConfig);
        if (this.keyExists("SERVICE")) {
            service = this.getValue("SERVICE");
            if (!service.trim().toUpperCase().startsWith("WCS")) {
                throw new WcsException("SERVICE parameter is wrong.");
            }
        } else {
            throw new WcsException("SERVICE parameter is mandatory.");
        }
        currentRequest.setService(service);
        if (this.keyExists("VERSION")) {
            version = this.getValue("VERSION");
            if (!version.equals("1.0.0")) {
                throw new WcsException("VERSION parameter is wrong.");
            }
        } else {
            throw new WcsException("VERSION parameter is mandatory.");
        }
        currentRequest.setVersion(version);
        if (this.keyExists("REQUEST")) {
            requestType = this.getValue("REQUEST");
            if (!requestType.equalsIgnoreCase("DescribeCoverage")) {
                throw new WcsException("REQUEST parameter is wrong.");
            }
        } else {
            throw new WcsException("REQUEST parameter is mandatory.");
        }
        currentRequest.setRequest(requestType);
        currentRequest.setHttpServletRequest(request);
        currentRequest.setVersion(this.getValue("VERSION"));
        currentRequest.setRequest(this.getValue("REQUEST"));
        currentRequest.setOutputFormat(this.getValue("OUTPUTFORMAT"));
        currentRequest.setCoverages(DescribeKvpReader.readFlat((String)this.getValue("COVERAGE"), (String)","));
        return currentRequest;
    }
}

