/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class CategoryDefinition
implements ToXContentObject {
    public static final ParseField TYPE = new ParseField("category_definition", new String[0]);
    public static final ParseField CATEGORY_ID = new ParseField("category_id", new String[0]);
    public static final ParseField TERMS = new ParseField("terms", new String[0]);
    public static final ParseField REGEX = new ParseField("regex", new String[0]);
    public static final ParseField MAX_MATCHING_LENGTH = new ParseField("max_matching_length", new String[0]);
    public static final ParseField EXAMPLES = new ParseField("examples", new String[0]);
    public static final ParseField GROK_PATTERN = new ParseField("grok_pattern", new String[0]);
    public static final ParseField NUM_MATCHES = new ParseField("num_matches", new String[0]);
    public static final ParseField PREFERRED_TO_CATEGORIES = new ParseField("preferred_to_categories", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("categories", new String[0]);
    public static final ConstructingObjectParser<CategoryDefinition, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), true, a -> new CategoryDefinition((String)a[0]));
    private final String jobId;
    private long categoryId = 0L;
    private String terms = "";
    private String regex = "";
    private long maxMatchingLength = 0L;
    private final Set<String> examples = new TreeSet<String>();
    private String grokPattern;
    private long numMatches = 0L;
    private List<Long> preferredToCategories;

    CategoryDefinition(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getCategoryId() {
        return this.categoryId;
    }

    void setCategoryId(long categoryId) {
        this.categoryId = categoryId;
    }

    public String getTerms() {
        return this.terms;
    }

    void setTerms(String terms) {
        this.terms = terms;
    }

    public String getRegex() {
        return this.regex;
    }

    void setRegex(String regex) {
        this.regex = regex;
    }

    public long getMaxMatchingLength() {
        return this.maxMatchingLength;
    }

    void setMaxMatchingLength(long maxMatchingLength) {
        this.maxMatchingLength = maxMatchingLength;
    }

    public List<String> getExamples() {
        return new ArrayList<String>(this.examples);
    }

    void setExamples(Collection<String> examples) {
        this.examples.clear();
        this.examples.addAll(examples);
    }

    void addExample(String example) {
        this.examples.add(example);
    }

    public String getGrokPattern() {
        return this.grokPattern;
    }

    void setGrokPattern(String grokPattern) {
        this.grokPattern = grokPattern;
    }

    public long getNumMatches() {
        return this.numMatches;
    }

    public void setNumMatches(long numMatches) {
        this.numMatches = numMatches;
    }

    public List<Long> getPreferredToCategories() {
        return this.preferredToCategories;
    }

    public void setPreferredToCategories(List<Long> preferredToCategories) {
        this.preferredToCategories = Collections.unmodifiableList(preferredToCategories);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(CATEGORY_ID.getPreferredName(), this.categoryId);
        builder.field(TERMS.getPreferredName(), this.terms);
        builder.field(REGEX.getPreferredName(), this.regex);
        builder.field(MAX_MATCHING_LENGTH.getPreferredName(), this.maxMatchingLength);
        builder.field(EXAMPLES.getPreferredName(), this.examples);
        if (this.grokPattern != null) {
            builder.field(GROK_PATTERN.getPreferredName(), this.grokPattern);
        }
        builder.field(NUM_MATCHES.getPreferredName(), this.numMatches);
        if (this.preferredToCategories != null && !this.preferredToCategories.isEmpty()) {
            builder.field(PREFERRED_TO_CATEGORIES.getPreferredName(), this.preferredToCategories);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CategoryDefinition that = (CategoryDefinition)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.categoryId, that.categoryId) && Objects.equals(this.terms, that.terms) && Objects.equals(this.regex, that.regex) && Objects.equals(this.maxMatchingLength, that.maxMatchingLength) && Objects.equals(this.examples, that.examples) && Objects.equals(this.preferredToCategories, that.preferredToCategories) && Objects.equals(this.numMatches, that.numMatches) && Objects.equals(this.grokPattern, that.grokPattern);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.categoryId, this.terms, this.regex, this.maxMatchingLength, this.examples, this.preferredToCategories, this.numMatches, this.grokPattern);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareLong(CategoryDefinition::setCategoryId, CATEGORY_ID);
        PARSER.declareString(CategoryDefinition::setTerms, TERMS);
        PARSER.declareString(CategoryDefinition::setRegex, REGEX);
        PARSER.declareLong(CategoryDefinition::setMaxMatchingLength, MAX_MATCHING_LENGTH);
        PARSER.declareStringArray(CategoryDefinition::setExamples, EXAMPLES);
        PARSER.declareString(CategoryDefinition::setGrokPattern, GROK_PATTERN);
        PARSER.declareLong(CategoryDefinition::setNumMatches, NUM_MATCHES);
        PARSER.declareLongArray(CategoryDefinition::setPreferredToCategories, PREFERRED_TO_CATEGORIES);
    }
}

