/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.security.TemplateRoleName;
import org.elasticsearch.client.security.support.expressiondsl.RoleMapperExpression;
import org.elasticsearch.client.security.support.expressiondsl.parser.RoleMapperExpressionParser;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public final class ExpressionRoleMapping {
    static final ConstructingObjectParser<ExpressionRoleMapping, String> PARSER = new ConstructingObjectParser("role-mapping", true, (args, name) -> new ExpressionRoleMapping((String)name, (RoleMapperExpression)args[0], (List)args[1], (List)args[2], (Map)args[3], (Boolean)args[4]));
    private final String name;
    private final RoleMapperExpression expression;
    private final List<String> roles;
    private final List<TemplateRoleName> roleTemplates;
    private final Map<String, Object> metadata;
    private final boolean enabled;

    public ExpressionRoleMapping(String name, RoleMapperExpression expr, List<String> roles, List<TemplateRoleName> templates, Map<String, Object> metadata, boolean enabled) {
        this.name = name;
        this.expression = expr;
        this.roles = roles == null ? Collections.emptyList() : Collections.unmodifiableList(roles);
        this.roleTemplates = templates == null ? Collections.emptyList() : Collections.unmodifiableList(templates);
        this.metadata = metadata == null ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public RoleMapperExpression getExpression() {
        return this.expression;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<TemplateRoleName> getRoleTemplates() {
        return this.roleTemplates;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionRoleMapping that = (ExpressionRoleMapping)o;
        return this.enabled == that.enabled && Objects.equals(this.name, that.name) && Objects.equals(this.expression, that.expression) && Objects.equals(this.roles, that.roles) && Objects.equals(this.roleTemplates, that.roleTemplates) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression, this.roles, this.roleTemplates, this.metadata, this.enabled);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> RoleMapperExpressionParser.fromXContent(parser), Fields.RULES, ObjectParser.ValueType.OBJECT);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), Fields.ROLES);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (parser, ctx) -> TemplateRoleName.fromXContent(parser), Fields.ROLE_TEMPLATES);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), XContentParser::map, Fields.METADATA, ObjectParser.ValueType.OBJECT);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), Fields.ENABLED);
    }

    public static interface Fields {
        public static final ParseField ROLES = new ParseField("roles", new String[0]);
        public static final ParseField ROLE_TEMPLATES = new ParseField("role_templates", new String[0]);
        public static final ParseField ENABLED = new ParseField("enabled", new String[0]);
        public static final ParseField RULES = new ParseField("rules", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    }
}

