/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.rollup.job.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class HistogramGroupConfig
implements Validatable,
ToXContentObject {
    static final String NAME = "histogram";
    private static final String INTERVAL = "interval";
    private static final String FIELDS = "fields";
    private static final ConstructingObjectParser<HistogramGroupConfig, Void> PARSER = new ConstructingObjectParser("histogram", true, args -> {
        List fields = (List)args[1];
        return new HistogramGroupConfig((Long)args[0], fields != null ? fields.toArray(new String[fields.size()]) : null);
    });
    private final long interval;
    private final String[] fields;

    public HistogramGroupConfig(long interval, String ... fields) {
        this.interval = interval;
        this.fields = fields;
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.fields == null || this.fields.length == 0) {
            validationException.addValidationError("Fields must have at least one value");
        }
        if (this.interval <= 0L) {
            validationException.addValidationError("Interval must be a positive long");
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public long getInterval() {
        return this.interval;
    }

    public String[] getFields() {
        return this.fields;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INTERVAL, this.interval);
        builder.field(FIELDS, (Object)this.fields);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HistogramGroupConfig that = (HistogramGroupConfig)other;
        return Objects.equals(this.interval, that.interval) && Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.interval, Arrays.hashCode(this.fields));
    }

    public static HistogramGroupConfig fromXContent(XContentParser parser) throws IOException {
        return (HistogramGroupConfig)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField(INTERVAL, new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField(FIELDS, new String[0]));
    }
}

