/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="HTTP Configuration")
public class HttpConfiguration {
    private List<Customizer> _customizers = new CopyOnWriteArrayList<Customizer>();
    private int _outputBufferSize = 32768;
    private int _requestHeaderSize = 8192;
    private int _responseHeaderSize = 8192;
    private int _securePort;
    private String _secureScheme = HttpScheme.HTTPS.asString();

    public HttpConfiguration() {
    }

    public HttpConfiguration(HttpConfiguration config) {
        this._customizers.addAll(config._customizers);
        this._outputBufferSize = config._outputBufferSize;
        this._requestHeaderSize = config._requestHeaderSize;
        this._responseHeaderSize = config._responseHeaderSize;
        this._securePort = config._securePort;
        this._secureScheme = config._secureScheme;
    }

    public void addCustomizer(Customizer customizer) {
        this._customizers.add(customizer);
    }

    public List<Customizer> getCustomizers() {
        return this._customizers;
    }

    public <T> T getCustomizer(Class<T> type) {
        for (Customizer c : this._customizers) {
            if (!type.isAssignableFrom(c.getClass())) continue;
            return (T)c;
        }
        return null;
    }

    @ManagedAttribute(value="The size in bytes of the output buffer used to aggregate HTTP output")
    public int getOutputBufferSize() {
        return this._outputBufferSize;
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for a HTTP request header")
    public int getRequestHeaderSize() {
        return this._requestHeaderSize;
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for a HTTP response header")
    public int getResponseHeaderSize() {
        return this._responseHeaderSize;
    }

    @ManagedAttribute(value="The port to which Integral or Confidential security constraints are redirected")
    public int getSecurePort() {
        return this._securePort;
    }

    @ManagedAttribute(value="The scheme with which Integral or Confidential security constraints are redirected")
    public String getSecureScheme() {
        return this._secureScheme;
    }

    public void setCustomizers(List<Customizer> customizers) {
        this._customizers.clear();
        this._customizers.addAll(customizers);
    }

    public void setOutputBufferSize(int responseBufferSize) {
        this._outputBufferSize = responseBufferSize;
    }

    public void setRequestHeaderSize(int requestHeaderSize) {
        this._requestHeaderSize = requestHeaderSize;
    }

    public void setResponseHeaderSize(int responseHeaderSize) {
        this._responseHeaderSize = responseHeaderSize;
    }

    public void setSecurePort(int confidentialPort) {
        this._securePort = confidentialPort;
    }

    public void setSecureScheme(String confidentialScheme) {
        this._secureScheme = confidentialScheme;
    }

    public String toString() {
        return String.format("%s@%x{%d,%d/%d,%s://:%d,%s}", this.getClass().getSimpleName(), this.hashCode(), this._outputBufferSize, this._requestHeaderSize, this._responseHeaderSize, this._secureScheme, this._securePort, this._customizers);
    }

    public static interface ConnectionFactory {
        public HttpConfiguration getHttpConfiguration();
    }

    public static interface Customizer {
        public void customize(Connector var1, HttpConfiguration var2, Request var3);
    }
}

