/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SslConnection
extends AbstractConnection {
    private static final Logger LOG = Log.getLogger(SslConnection.class);
    private static final ByteBuffer __FILL_CALLED_FLUSH = BufferUtil.allocate(0);
    private static final ByteBuffer __FLUSH_CALLED_FILL = BufferUtil.allocate(0);
    private final ByteBufferPool _bufferPool;
    private final SSLEngine _sslEngine;
    private final DecryptedEndPoint _decryptedEndPoint;
    private ByteBuffer _decryptedInput;
    private ByteBuffer _encryptedInput;
    private ByteBuffer _encryptedOutput;
    private final boolean _encryptedDirectBuffers = true;
    private final boolean _decryptedDirectBuffers = false;
    private boolean _renegotiationAllowed;
    private final Runnable _runCompletWrite = new Runnable(){

        @Override
        public void run() {
            SslConnection.this._decryptedEndPoint.getWriteFlusher().completeWrite();
        }
    };
    private final Runnable _runFillable = new Runnable(){

        @Override
        public void run() {
            SslConnection.this._decryptedEndPoint.getFillInterest().fillable();
        }
    };

    public SslConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, SSLEngine sslEngine) {
        super(endPoint, executor);
        this._bufferPool = byteBufferPool;
        this._sslEngine = sslEngine;
        this._decryptedEndPoint = this.newDecryptedEndPoint();
    }

    protected DecryptedEndPoint newDecryptedEndPoint() {
        return new DecryptedEndPoint();
    }

    public SSLEngine getSSLEngine() {
        return this._sslEngine;
    }

    public DecryptedEndPoint getDecryptedEndPoint() {
        return this._decryptedEndPoint;
    }

    public boolean isRenegotiationAllowed() {
        return this._renegotiationAllowed;
    }

    public void setRenegotiationAllowed(boolean renegotiationAllowed) {
        this._renegotiationAllowed = renegotiationAllowed;
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.getDecryptedEndPoint().getConnection().onOpen();
    }

    @Override
    public void onClose() {
        this._decryptedEndPoint.getConnection().onClose();
        super.onClose();
    }

    @Override
    public void close() {
        this.getDecryptedEndPoint().getConnection().close();
    }

    @Override
    public boolean onIdleExpired() {
        return this.getDecryptedEndPoint().getConnection().onIdleExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFillable enter {}", this._decryptedEndPoint);
        }
        if (this._decryptedEndPoint.isInputShutdown()) {
            this._decryptedEndPoint.close();
        }
        this._decryptedEndPoint.getFillInterest().fillable();
        DecryptedEndPoint decryptedEndPoint = this._decryptedEndPoint;
        synchronized (decryptedEndPoint) {
            if (this._decryptedEndPoint._flushRequiresFillToProgress) {
                this._decryptedEndPoint._flushRequiresFillToProgress = false;
                this._runCompletWrite.run();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFillable exit {}", this._decryptedEndPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillInterestedFailed(Throwable cause) {
        this._decryptedEndPoint.getFillInterest().onFail(cause);
        boolean failFlusher = false;
        DecryptedEndPoint decryptedEndPoint = this._decryptedEndPoint;
        synchronized (decryptedEndPoint) {
            if (this._decryptedEndPoint._flushRequiresFillToProgress) {
                this._decryptedEndPoint._flushRequiresFillToProgress = false;
                failFlusher = true;
            }
        }
        if (failFlusher) {
            this._decryptedEndPoint.getWriteFlusher().onFail(cause);
        }
    }

    @Override
    public String toString() {
        ByteBuffer b = this._encryptedInput;
        int ei = b == null ? -1 : b.remaining();
        b = this._encryptedOutput;
        int eo = b == null ? -1 : b.remaining();
        b = this._decryptedInput;
        int di = b == null ? -1 : b.remaining();
        return String.format("SslConnection@%x{%s,eio=%d/%d,di=%d} -> %s", new Object[]{this.hashCode(), this._sslEngine.getHandshakeStatus(), ei, eo, di, this._decryptedEndPoint.getConnection()});
    }

    static /* synthetic */ ByteBuffer access$1202(SslConnection x0, ByteBuffer x1) {
        x0._encryptedInput = x1;
        return x0._encryptedInput;
    }

    static /* synthetic */ ByteBuffer access$1102(SslConnection x0, ByteBuffer x1) {
        x0._decryptedInput = x1;
        return x0._decryptedInput;
    }

    static /* synthetic */ Executor access$1800(SslConnection x0) {
        return x0.getExecutor();
    }

    public class DecryptedEndPoint
    extends AbstractEndPoint {
        private boolean _fillRequiresFlushToProgress;
        private boolean _flushRequiresFillToProgress;
        private boolean _cannotAcceptMoreAppDataToFlush;
        private boolean _handshaken;
        private boolean _underFlown;
        private final Callback _writeCallback;

        public DecryptedEndPoint() {
            super(null, SslConnection.this.getEndPoint().getLocalAddress(), SslConnection.this.getEndPoint().getRemoteAddress());
            this._writeCallback = new Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void succeeded() {
                    boolean fillable = false;
                    DecryptedEndPoint decryptedEndPoint = DecryptedEndPoint.this;
                    synchronized (decryptedEndPoint) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("write.complete {}", SslConnection.this.getEndPoint());
                        }
                        DecryptedEndPoint.this.releaseEncryptedOutputBuffer();
                        DecryptedEndPoint.this._cannotAcceptMoreAppDataToFlush = false;
                        if (DecryptedEndPoint.this._fillRequiresFlushToProgress) {
                            DecryptedEndPoint.this._fillRequiresFlushToProgress = false;
                            fillable = true;
                        }
                    }
                    if (fillable) {
                        DecryptedEndPoint.this.getFillInterest().fillable();
                    }
                    SslConnection.this._runCompletWrite.run();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void failed(Throwable x) {
                    boolean fail_filler = false;
                    DecryptedEndPoint decryptedEndPoint = DecryptedEndPoint.this;
                    synchronized (decryptedEndPoint) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} write.failed", SslConnection.this, x);
                        }
                        BufferUtil.clear(SslConnection.this._encryptedOutput);
                        DecryptedEndPoint.this.releaseEncryptedOutputBuffer();
                        DecryptedEndPoint.this._cannotAcceptMoreAppDataToFlush = false;
                        if (DecryptedEndPoint.this._fillRequiresFlushToProgress) {
                            DecryptedEndPoint.this._fillRequiresFlushToProgress = false;
                            fail_filler = true;
                        }
                    }
                    final boolean filler_failed = fail_filler;
                    SslConnection.this.failedCallback(new Callback(){

                        @Override
                        public void succeeded() {
                        }

                        @Override
                        public void failed(Throwable x) {
                            if (filler_failed) {
                                DecryptedEndPoint.this.getFillInterest().onFail(x);
                            }
                            DecryptedEndPoint.this.getWriteFlusher().onFail(x);
                        }
                    }, x);
                }
            };
            super.setIdleTimeout(-1L);
        }

        @Override
        public long getIdleTimeout() {
            return SslConnection.this.getEndPoint().getIdleTimeout();
        }

        @Override
        public void setIdleTimeout(long idleTimeout) {
            SslConnection.this.getEndPoint().setIdleTimeout(idleTimeout);
        }

        @Override
        public boolean isOpen() {
            return SslConnection.this.getEndPoint().isOpen();
        }

        @Override
        protected WriteFlusher getWriteFlusher() {
            return super.getWriteFlusher();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onIncompleteFlush() {
            boolean try_again = false;
            DecryptedEndPoint decryptedEndPoint = this;
            synchronized (decryptedEndPoint) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onIncompleteFlush {}", SslConnection.this);
                }
                if (BufferUtil.hasContent(SslConnection.this._encryptedOutput)) {
                    this._cannotAcceptMoreAppDataToFlush = true;
                    SslConnection.this.getEndPoint().write(this._writeCallback, SslConnection.this._encryptedOutput);
                } else if (SslConnection.this._sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    this._flushRequiresFillToProgress = true;
                    this.ensureFillInterested();
                } else {
                    try_again = true;
                }
            }
            if (try_again) {
                if (this.isOutputShutdown()) {
                    this.getWriteFlusher().onClose();
                } else {
                    SslConnection.this.getExecutor().execute(SslConnection.this._runCompletWrite);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void needsFillInterest() throws IOException {
            DecryptedEndPoint decryptedEndPoint = this;
            synchronized (decryptedEndPoint) {
                boolean fillable;
                boolean bl = fillable = BufferUtil.hasContent(SslConnection.this._decryptedInput) || BufferUtil.hasContent(SslConnection.this._encryptedInput) && !this._underFlown;
                if (!fillable && this._fillRequiresFlushToProgress) {
                    if (BufferUtil.hasContent(SslConnection.this._encryptedOutput)) {
                        this._cannotAcceptMoreAppDataToFlush = true;
                        SslConnection.this.getEndPoint().write(this._writeCallback, SslConnection.this._encryptedOutput);
                    } else {
                        this._fillRequiresFlushToProgress = false;
                        fillable = true;
                    }
                }
                if (fillable) {
                    SslConnection.this.getExecutor().execute(SslConnection.this._runFillable);
                } else {
                    this.ensureFillInterested();
                }
            }
        }

        @Override
        public void setConnection(Connection connection) {
            AbstractConnection a;
            if (connection instanceof AbstractConnection && (a = (AbstractConnection)connection).getInputBufferSize() < SslConnection.this._sslEngine.getSession().getApplicationBufferSize()) {
                a.setInputBufferSize(SslConnection.this._sslEngine.getSession().getApplicationBufferSize());
            }
            super.setConnection(connection);
        }

        public SslConnection getSslConnection() {
            return SslConnection.this;
        }

        /*
         * Exception decompiling
         */
        @Override
        public synchronized int fill(ByteBuffer buffer) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[CASE]], but top level block is 12[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void closeInbound() {
            try {
                SslConnection.this._sslEngine.closeInbound();
            }
            catch (SSLException x) {
                LOG.ignore(x);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean flush(ByteBuffer ... appOuts) throws IOException {
            if (LOG.isDebugEnabled()) {
                for (ByteBuffer b : appOuts) {
                    LOG.debug("{} flush {}", SslConnection.this, BufferUtil.toHexSummary(b));
                }
            }
            try {
                if (this._cannotAcceptMoreAppDataToFlush) {
                    if (SslConnection.this._sslEngine.isOutboundDone()) {
                        throw new EofException(new ClosedChannelException());
                    }
                    boolean bl = false;
                    return bl;
                }
                if (SslConnection.this._encryptedOutput == null) {
                    SslConnection.this._encryptedOutput = SslConnection.this._bufferPool.acquire(SslConnection.this._sslEngine.getSession().getPacketBufferSize(), true);
                }
                block24: while (true) {
                    int n;
                    SSLEngineResult wrapResult;
                    BufferUtil.compact(SslConnection.this._encryptedOutput);
                    int pos = BufferUtil.flipToFill(SslConnection.this._encryptedOutput);
                    try {
                        wrapResult = SslConnection.this._sslEngine.wrap(appOuts, SslConnection.this._encryptedOutput);
                    }
                    finally {
                        BufferUtil.flipToFlush(SslConnection.this._encryptedOutput, pos);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} wrap {}", SslConnection.this, wrapResult.toString().replace('\n', ' '));
                    }
                    SSLEngineResult.Status wrapResultStatus = wrapResult.getStatus();
                    int allConsumed = 1;
                    for (ByteBuffer b : appOuts) {
                        if (!BufferUtil.hasContent(b)) continue;
                        allConsumed = 0;
                    }
                    switch (wrapResultStatus) {
                        case CLOSED: {
                            if (BufferUtil.hasContent(SslConnection.this._encryptedOutput)) {
                                this._cannotAcceptMoreAppDataToFlush = true;
                                SslConnection.this.getEndPoint().flush(SslConnection.this._encryptedOutput);
                                SslConnection.this.getEndPoint().shutdownOutput();
                                if (BufferUtil.hasContent(SslConnection.this._encryptedOutput)) {
                                    boolean bl = false;
                                    return bl;
                                }
                            } else {
                                SslConnection.this.getEndPoint().shutdownOutput();
                            }
                            int n2 = allConsumed;
                            return n2 != 0;
                        }
                        case BUFFER_UNDERFLOW: {
                            throw new IllegalStateException();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} wrap {} {}", new Object[]{SslConnection.this, wrapResultStatus, BufferUtil.toHexSummary(SslConnection.this._encryptedOutput)});
                    }
                    if (wrapResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED && !this._handshaken) {
                        this._handshaken = true;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} server handshook complete {}/{}", SslConnection.this, SslConnection.this._sslEngine.getSession().getProtocol(), SslConnection.this._sslEngine.getSession().getCipherSuite());
                        }
                    }
                    SSLEngineResult.HandshakeStatus handshakeStatus = SslConnection.this._sslEngine.getHandshakeStatus();
                    if (this._handshaken && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && !SslConnection.this.isRenegotiationAllowed()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} renegotiation denied", SslConnection.this);
                        }
                        SslConnection.this.getEndPoint().shutdownOutput();
                        n = allConsumed;
                        return n != 0;
                    }
                    if (BufferUtil.hasContent(SslConnection.this._encryptedOutput) && !SslConnection.this.getEndPoint().flush(SslConnection.this._encryptedOutput)) {
                        SslConnection.this.getEndPoint().flush(SslConnection.this._encryptedOutput);
                    }
                    switch (handshakeStatus) {
                        case NOT_HANDSHAKING: {
                            if (!allConsumed && wrapResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED && BufferUtil.isEmpty(SslConnection.this._encryptedOutput)) continue block24;
                            n = allConsumed != 0 && BufferUtil.isEmpty(SslConnection.this._encryptedOutput) ? 1 : 0;
                            return n != 0;
                        }
                        case NEED_TASK: {
                            SslConnection.this._sslEngine.getDelegatedTask().run();
                            continue block24;
                        }
                        case NEED_WRAP: {
                            continue block24;
                        }
                        case NEED_UNWRAP: {
                            if (appOuts[0] != __FILL_CALLED_FLUSH && !this.getFillInterest().isInterested()) {
                                this._flushRequiresFillToProgress = true;
                                this.fill(__FLUSH_CALLED_FILL);
                                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) continue block24;
                            }
                            n = allConsumed != 0 && BufferUtil.isEmpty(SslConnection.this._encryptedOutput) ? 1 : 0;
                            return n != 0;
                        }
                        case FINISHED: {
                            throw new IllegalStateException();
                        }
                    }
                }
            }
            finally {
                this.releaseEncryptedOutputBuffer();
            }
        }

        private void releaseEncryptedOutputBuffer() {
            if (!Thread.holdsLock(this)) {
                throw new IllegalStateException();
            }
            if (SslConnection.this._encryptedOutput != null && !SslConnection.this._encryptedOutput.hasRemaining()) {
                SslConnection.this._bufferPool.release(SslConnection.this._encryptedOutput);
                SslConnection.this._encryptedOutput = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdownOutput() {
            boolean ishut = this.isInputShutdown();
            boolean oshut = this.isOutputShutdown();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} shutdownOutput: oshut={}, ishut={}", SslConnection.this, oshut, ishut);
            }
            if (ishut) {
                SslConnection.this.getEndPoint().close();
            } else if (!oshut) {
                try {
                    DecryptedEndPoint decryptedEndPoint = this;
                    synchronized (decryptedEndPoint) {
                        SslConnection.this._sslEngine.closeOutbound();
                        this.flush(BufferUtil.EMPTY_BUFFER);
                        this.ensureFillInterested();
                    }
                }
                catch (Exception e) {
                    LOG.ignore(e);
                    SslConnection.this.getEndPoint().close();
                }
            }
        }

        private void ensureFillInterested() {
            if (!SslConnection.this.isFillInterested()) {
                SslConnection.this.fillInterested();
            }
        }

        @Override
        public boolean isOutputShutdown() {
            return SslConnection.this._sslEngine.isOutboundDone() || SslConnection.this.getEndPoint().isOutputShutdown();
        }

        @Override
        public void close() {
            this.shutdownOutput();
            SslConnection.this.getEndPoint().close();
            super.close();
        }

        @Override
        public Object getTransport() {
            return SslConnection.this.getEndPoint();
        }

        @Override
        public boolean isInputShutdown() {
            return SslConnection.this._sslEngine.isInboundDone();
        }

        @Override
        public String toString() {
            return super.toString() + "->" + SslConnection.this.getEndPoint().toString();
        }
    }
}

