/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class JettyStopMojo
extends AbstractMojo {
    protected int stopPort;
    protected String stopKey;
    protected int stopWait;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.stopPort <= 0) {
            throw new MojoExecutionException("Please specify a valid port");
        }
        if (this.stopKey == null) {
            throw new MojoExecutionException("Please specify a valid stopKey");
        }
        try {
            Socket s = new Socket(InetAddress.getByName("127.0.0.1"), this.stopPort);
            s.setSoLinger(false, 0);
            OutputStream out = s.getOutputStream();
            out.write((this.stopKey + "\r\nstop\r\n").getBytes());
            out.flush();
            if (this.stopWait > 0) {
                String response;
                s.setSoTimeout(this.stopWait * 1000);
                s.getInputStream();
                System.err.printf("Waiting %d seconds for jetty to stop%n", this.stopWait);
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                boolean stopped = false;
                while (!stopped && (response = lin.readLine()) != null) {
                    if (!"Stopped".equals(response)) continue;
                    stopped = true;
                    System.err.println("Server reports itself as Stopped");
                }
            }
            s.close();
        }
        catch (ConnectException e) {
            this.getLog().info((CharSequence)"Jetty not running!");
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
    }

    public String getStopKey() {
        return this.stopKey;
    }

    public void setStopKey(String stopKey) {
        this.stopKey = stopKey;
    }
}

