/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.util.Arrays;
import org.eclipse.jetty.security.UserDataConstraint;
import org.eclipse.jetty.util.LazyList;

public class RoleInfo {
    private static final String[] NO_ROLES = new String[0];
    private boolean _isAnyRole;
    private boolean _checked;
    private boolean _forbidden;
    private UserDataConstraint _userDataConstraint;
    private String[] _roles = NO_ROLES;

    public boolean isChecked() {
        return this._checked;
    }

    public void setChecked(boolean checked) {
        this._checked = checked;
        if (!checked) {
            this._forbidden = false;
            this._roles = NO_ROLES;
            this._isAnyRole = false;
        }
    }

    public boolean isForbidden() {
        return this._forbidden;
    }

    public void setForbidden(boolean forbidden) {
        this._forbidden = forbidden;
        if (forbidden) {
            this._checked = true;
            this._userDataConstraint = null;
            this._isAnyRole = false;
            this._roles = NO_ROLES;
        }
    }

    public boolean isAnyRole() {
        return this._isAnyRole;
    }

    public void setAnyRole(boolean anyRole) {
        this._isAnyRole = anyRole;
        if (anyRole) {
            this._checked = true;
            this._roles = NO_ROLES;
        }
    }

    public UserDataConstraint getUserDataConstraint() {
        return this._userDataConstraint;
    }

    public void setUserDataConstraint(UserDataConstraint userDataConstraint) {
        if (userDataConstraint == null) {
            throw new NullPointerException("Null UserDataConstraint");
        }
        this._userDataConstraint = this._userDataConstraint == null ? userDataConstraint : this._userDataConstraint.combine(userDataConstraint);
    }

    public String[] getRoles() {
        return this._roles;
    }

    public void addRole(String role) {
        this._roles = (String[])LazyList.addToArray(this._roles, role, String.class);
    }

    public void combine(RoleInfo other) {
        if (other._forbidden) {
            this.setForbidden(true);
        } else if (!other._checked) {
            this.setChecked(true);
        } else if (other._isAnyRole) {
            this.setAnyRole(true);
        } else if (!this._isAnyRole) {
            for (String r : other._roles) {
                this._roles = (String[])LazyList.addToArray(this._roles, r, String.class);
            }
        }
        this.setUserDataConstraint(other._userDataConstraint);
    }

    public String toString() {
        return "{RoleInfo" + (this._forbidden ? ",F" : "") + (this._checked ? ",C" : "") + (this._isAnyRole ? ",*" : Arrays.asList(this._roles).toString()) + "}";
    }
}

