/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jetty.client.util.AbstractTypedContentProvider;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class PathContentProvider
extends AbstractTypedContentProvider {
    private static final Logger LOG = Log.getLogger(PathContentProvider.class);
    private final Path filePath;
    private final long fileSize;
    private final int bufferSize;

    public PathContentProvider(Path filePath) throws IOException {
        this(filePath, 4096);
    }

    public PathContentProvider(Path filePath, int bufferSize) throws IOException {
        this("application/octet-stream", filePath, bufferSize);
    }

    public PathContentProvider(String contentType, Path filePath) throws IOException {
        this(contentType, filePath, 4096);
    }

    public PathContentProvider(String contentType, Path filePath, int bufferSize) throws IOException {
        super(contentType);
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            throw new NoSuchFileException(filePath.toString());
        }
        if (!Files.isReadable(filePath)) {
            throw new AccessDeniedException(filePath.toString());
        }
        this.filePath = filePath;
        this.fileSize = Files.size(filePath);
        this.bufferSize = bufferSize;
    }

    @Override
    public long getLength() {
        return this.fileSize;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new PathIterator();
    }

    private class PathIterator
    implements Iterator<ByteBuffer>,
    Closeable {
        private final ByteBuffer buffer;
        private SeekableByteChannel channel;
        private long position;

        private PathIterator() {
            this.buffer = ByteBuffer.allocateDirect(PathContentProvider.this.bufferSize);
        }

        @Override
        public boolean hasNext() {
            return this.position < PathContentProvider.this.getLength();
        }

        @Override
        public ByteBuffer next() {
            try {
                if (this.channel == null) {
                    this.channel = Files.newByteChannel(PathContentProvider.this.filePath, StandardOpenOption.READ);
                    LOG.debug("Opened file {}", PathContentProvider.this.filePath);
                }
                this.buffer.clear();
                int read = this.channel.read(this.buffer);
                if (read < 0) {
                    throw new NoSuchElementException();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes from {}", read, PathContentProvider.this.filePath);
                }
                this.position += (long)read;
                if (!this.hasNext()) {
                    this.close();
                }
                this.buffer.flip();
                return this.buffer;
            }
            catch (NoSuchElementException x) {
                this.close();
                throw x;
            }
            catch (Exception x) {
                this.close();
                throw (NoSuchElementException)new NoSuchElementException().initCause(x);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (Exception x) {
                LOG.ignore(x);
            }
        }
    }
}

