/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.RandomAccess;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.impl.list.mutable.AbstractMutableList;
import org.eclipse.collections.impl.utility.Iterate;

public class BoxedMutableIntList
extends AbstractMutableList<Integer>
implements MutableList<Integer>,
RandomAccess {
    private final MutableIntList delegate;

    public BoxedMutableIntList(MutableIntList delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean add(Integer item) {
        return this.delegate.add(item.intValue());
    }

    public boolean addAll(int index, Collection<? extends Integer> c) {
        int[] target = new int[c.size()];
        Iterate.forEachWithIndex(c, (ObjectIntProcedure & Serializable)(each, parameter) -> {
            target[parameter] = each;
        });
        return this.delegate.addAllAtIndex(index, target);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Integer get(int index) {
        return this.delegate.get(index);
    }

    public Integer set(int index, Integer element) {
        return this.delegate.set(index, element.intValue());
    }

    public void add(int index, Integer element) {
        this.delegate.addAtIndex(index, element.intValue());
    }

    public Integer remove(int index) {
        return this.delegate.removeAtIndex(index);
    }

    @Override
    public int indexOf(Object o) {
        return o instanceof Integer ? this.delegate.indexOf(((Integer)o).intValue()) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return o instanceof Integer ? this.delegate.lastIndexOf(((Integer)o).intValue()) : -1;
    }

    @Override
    public MutableList<Integer> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex).boxed();
    }
}

