/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.FloatBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.FloatIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.factory.primitive.FloatSets;
import org.eclipse.collections.impl.iterator.SingletonFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableFloatSingletonBag
implements ImmutableFloatBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final float element1;

    ImmutableFloatSingletonBag(float element) {
        this.element1 = element;
    }

    public ImmutableFloatBag newWith(float element) {
        return FloatBags.immutable.with(new float[]{this.element1, element});
    }

    public ImmutableFloatBag newWithout(float element) {
        return Float.compare(this.element1, element) == 0 ? FloatBags.immutable.with() : this;
    }

    public ImmutableFloatBag newWithAll(FloatIterable elements) {
        return FloatHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    public ImmutableFloatBag newWithoutAll(FloatIterable elements) {
        return elements.contains(this.element1) ? FloatBags.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(float value) {
        return Float.compare(this.element1, value) == 0;
    }

    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (Float.compare(this.element1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.element1, value) == 0) continue;
            return false;
        }
        return true;
    }

    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public void each(FloatProcedure procedure) {
        procedure.value(this.element1);
    }

    public ImmutableFloatBag select(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? FloatBags.immutable.with(this.element1) : FloatBags.immutable.empty();
    }

    public ImmutableFloatBag selectByOccurrences(IntPredicate predicate) {
        return predicate.accept(1) ? FloatBags.immutable.with(this.element1) : FloatBags.immutable.empty();
    }

    public ImmutableFloatSet selectUnique() {
        return FloatSets.immutable.of(this.element1);
    }

    public ImmutableList<FloatIntPair> topOccurrences(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        if (count == 0) {
            return Lists.immutable.empty();
        }
        return Lists.immutable.with((Object)PrimitiveTuples.pair(this.element1, 1));
    }

    public ImmutableList<FloatIntPair> bottomOccurrences(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        if (count == 0) {
            return Lists.immutable.empty();
        }
        return Lists.immutable.with((Object)PrimitiveTuples.pair(this.element1, 1));
    }

    public ImmutableFloatBag reject(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? FloatBags.immutable.empty() : FloatBags.immutable.with(this.element1);
    }

    public <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        return Bags.immutable.with(function.valueOf(this.element1));
    }

    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.element1);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(float item) {
        return Float.compare(this.element1, item) == 0 ? 1 : 0;
    }

    public void forEachWithOccurrences(FloatIntProcedure floatIntProcedure) {
        floatIntProcedure.value(this.element1, 1);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public int count(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public double sum() {
        return this.element1;
    }

    public float min() {
        return this.element1;
    }

    public float max() {
        return this.element1;
    }

    public float maxIfEmpty(float defaultValue) {
        return this.element1;
    }

    public float minIfEmpty(float defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public float[] toSortedArray() {
        return new float[]{this.element1};
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.element1);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public RichIterable<FloatIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with((Object)this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatBag)) {
            return false;
        }
        FloatBag bag = (FloatBag)obj;
        if (bag.size() != 1) {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.element1) ^ 1;
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.element1);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.element1);
    }

    public ImmutableFloatBag toImmutable() {
        return this;
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public float[] toArray() {
        return new float[]{this.element1};
    }

    public float[] toArray(float[] target) {
        if (target.length < 1) {
            target = new float[]{this.element1};
        } else {
            target[0] = this.element1;
        }
        return target;
    }

    public String toString() {
        return '[' + this.makeString() + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FloatIterator floatIterator() {
        return new SingletonFloatIterator(this.element1);
    }
}

