/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.original;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.duplications.detector.original.BlocksGroup;
import org.sonar.duplications.detector.original.Filter;
import org.sonar.duplications.index.CloneGroup;
import org.sonar.duplications.index.CloneIndex;
import org.sonar.duplications.index.ClonePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OriginalCloneDetectionAlgorithm {
    private final CloneIndex cloneIndex;
    private final Filter filter = new Filter();
    private String originResourceId;

    public static List<CloneGroup> detect(CloneIndex cloneIndex, Collection<Block> fileBlocks) {
        if (fileBlocks.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        OriginalCloneDetectionAlgorithm reporter = new OriginalCloneDetectionAlgorithm(cloneIndex);
        reporter.findClones(fileBlocks);
        return reporter.filter.getResult();
    }

    private OriginalCloneDetectionAlgorithm(CloneIndex cloneIndex) {
        this.cloneIndex = cloneIndex;
    }

    private BlocksGroup[] createGroups(Collection<Block> fileBlocks) {
        ByteArray hash;
        int size = fileBlocks.size();
        HashMap groupsByHash = Maps.newHashMap();
        for (Block block : fileBlocks) {
            hash = block.getBlockHash();
            BlocksGroup sameHash = (BlocksGroup)groupsByHash.get(hash);
            if (sameHash == null) {
                sameHash = BlocksGroup.empty();
                groupsByHash.put(hash, sameHash);
            }
            sameHash.blocks.add(block);
        }
        for (Map.Entry entry : groupsByHash.entrySet()) {
            hash = (ByteArray)entry.getKey();
            BlocksGroup group = (BlocksGroup)entry.getValue();
            for (Block blockFromIndex : this.cloneIndex.getBySequenceHash(hash)) {
                if (this.originResourceId.equals(blockFromIndex.getResourceId())) continue;
                group.blocks.add(blockFromIndex);
            }
            Collections.sort(group.blocks, BlocksGroup.BlockComparator.INSTANCE);
        }
        BlocksGroup[] sameHashBlocksGroups = new BlocksGroup[size + 2];
        sameHashBlocksGroups[0] = BlocksGroup.empty();
        for (Block fileBlock : fileBlocks) {
            ByteArray hash2 = fileBlock.getBlockHash();
            int i = fileBlock.getIndexInFile() + 1;
            sameHashBlocksGroups[i] = (BlocksGroup)groupsByHash.get(hash2);
        }
        sameHashBlocksGroups[size + 1] = BlocksGroup.empty();
        return sameHashBlocksGroups;
    }

    private void findClones(Collection<Block> fileBlocks) {
        this.originResourceId = fileBlocks.iterator().next().getResourceId();
        BlocksGroup[] sameHashBlocksGroups = this.createGroups(fileBlocks);
        block0: for (int i = 1; i < sameHashBlocksGroups.length; ++i) {
            if (sameHashBlocksGroups[i].size() < 2 || sameHashBlocksGroups[i].subsumedBy(sameHashBlocksGroups[i - 1], 1)) continue;
            BlocksGroup currentBlocksGroup = sameHashBlocksGroups[i];
            for (int j = i + 1; j < sameHashBlocksGroups.length; ++j) {
                Block first;
                BlocksGroup intersectedBlocksGroup = currentBlocksGroup.intersect(sameHashBlocksGroups[j]);
                if (intersectedBlocksGroup.size() < currentBlocksGroup.size() && (first = currentBlocksGroup.first(this.originResourceId)).getIndexInFile() == j - 2) {
                    this.reportClones(sameHashBlocksGroups[i], currentBlocksGroup, j - i);
                }
                if ((currentBlocksGroup = intersectedBlocksGroup).size() < 2 || currentBlocksGroup.subsumedBy(sameHashBlocksGroups[i - 1], j - i + 1)) continue block0;
            }
        }
    }

    private void reportClones(BlocksGroup beginGroup, BlocksGroup endGroup, int cloneLength) {
        List<Block[]> pairs = beginGroup.pairs(endGroup, cloneLength);
        ClonePart origin = null;
        ArrayList parts = Lists.newArrayList();
        for (int i = 0; i < pairs.size(); ++i) {
            Block[] pair = pairs.get(i);
            ClonePart part = new ClonePart(pair[0].getResourceId(), pair[0].getIndexInFile(), pair[0].getFirstLineNumber(), pair[1].getLastLineNumber());
            parts.add(part);
            if (!this.originResourceId.equals(part.getResourceId())) continue;
            if (origin == null) {
                origin = part;
                continue;
            }
            if (part.getUnitStart() >= origin.getUnitStart()) continue;
            origin = part;
        }
        this.filter.add(new CloneGroup(cloneLength, origin, parts));
    }
}

