/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.block;

import org.sonar.duplications.block.ByteArray;

public final class Block {
    private final String resourceId;
    private final ByteArray blockHash;
    private final int indexInFile;
    private final int firstLineNumber;
    private final int lastLineNumber;
    private int hash;

    public Block(String resourceId, ByteArray blockHash, int indexInFile, int firstLineNumber, int lastLineNumber) {
        this.resourceId = resourceId;
        this.blockHash = blockHash;
        this.indexInFile = indexInFile;
        this.firstLineNumber = firstLineNumber;
        this.lastLineNumber = lastLineNumber;
    }

    public Block(int indexInFile, int firstLineNumber, int lastLineNumber, String resourceId, String hash) {
        this(resourceId, new ByteArray(hash), indexInFile, firstLineNumber, lastLineNumber);
    }

    public String getHashHex() {
        return this.getBlockHash().toString();
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ByteArray getBlockHash() {
        return this.blockHash;
    }

    public int getIndexInFile() {
        return this.indexInFile;
    }

    public int getFirstLineNumber() {
        return this.firstLineNumber;
    }

    public int getLastLineNumber() {
        return this.lastLineNumber;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Block)) {
            return false;
        }
        Block other = (Block)obj;
        return this.resourceId.equals(other.resourceId) && this.blockHash.equals(other.blockHash) && this.indexInFile == other.indexInFile && this.firstLineNumber == other.firstLineNumber && this.lastLineNumber == other.lastLineNumber;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.resourceId.hashCode();
            h = 31 * h + this.blockHash.hashCode();
            h = 31 * h + this.indexInFile;
            h = 31 * h + this.firstLineNumber;
            this.hash = h = 31 * h + this.lastLineNumber;
        }
        return h;
    }

    public String toString() {
        return "'" + this.resourceId + "'[" + this.indexInFile + "|" + this.firstLineNumber + "-" + this.lastLineNumber + "]:" + this.blockHash;
    }
}

