/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.entity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.sonar.report.pdf.PDFReporter;
import org.sonar.report.pdf.entity.FileInfo;
import org.sonar.report.pdf.entity.Measure;
import org.sonar.report.pdf.entity.Measures;
import org.sonar.report.pdf.entity.Priority;
import org.sonar.report.pdf.entity.Rule;
import org.sonar.report.pdf.entity.exception.ReportException;
import org.sonar.report.pdf.util.Logger;
import org.sonar.report.pdf.util.SonarAccess;
import org.sonar.report.pdf.util.UrlPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private short id;
    private String key;
    private String name;
    private String description;
    private List<String> links;
    private Measures measures;
    private List<Project> subprojects;
    private List<Rule> mostViolatedRules;
    private List<FileInfo> mostComplexFiles;
    private List<FileInfo> mostViolatedFiles;
    private List<FileInfo> mostDuplicatedFiles;
    private static final String PROJECT = "//resources/resource";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String ALL_MEASURES = "msr";
    private static final String MEASURE_FRMT_VAL = "frmt_val";
    private static final String DESCRIPTION = "description";

    public Project(String key) {
        this.key = key;
    }

    public void initializeProject(SonarAccess sonarAccess) throws IOException, DocumentException, ReportException {
        Logger.info("Retrieving project info for " + this.key);
        Document parent = sonarAccess.getUrlAsDocument("/api/resources?resource=" + this.key + "&depth=0" + "&format=xml");
        if (parent.selectSingleNode(PROJECT) != null) {
            this.initFromNode(parent.selectSingleNode(PROJECT));
            this.initMeasures(sonarAccess);
            this.initMostViolatedRules(sonarAccess);
            this.initMostViolatedFiles(sonarAccess);
            this.initMostComplexElements(sonarAccess);
            this.initMostDuplicatedFiles(sonarAccess);
            Logger.debug("Accessing Sonar: getting child projects");
            Document childs = sonarAccess.getUrlAsDocument("/api/resources?resource=" + this.key + "&depth=1" + "&format=xml");
            List childNodes = childs.selectNodes(PROJECT);
            Iterator it = childNodes.iterator();
            this.setSubprojects(new ArrayList<Project>());
            if (!it.hasNext()) {
                Logger.debug(this.key + " project has no childs");
            }
            while (it.hasNext()) {
                Node childNode = (Node)it.next();
                if (!childNode.selectSingleNode("scope").getText().equals("PRJ")) continue;
                Project childProject = new Project(childNode.selectSingleNode(KEY).getText());
                childProject.initializeProject(sonarAccess);
                this.getSubprojects().add(childProject);
            }
        } else {
            Logger.info("Can't retrieve project info. Have you set username/password in Sonar settings?");
            throw new ReportException("Can't retrieve project info. Parent project node is empty. Authentication?");
        }
    }

    private void initFromNode(Node projectNode) {
        Node description;
        Node name = projectNode.selectSingleNode(NAME);
        if (name != null) {
            this.setName(name.getText());
        }
        if ((description = projectNode.selectSingleNode(DESCRIPTION)) != null) {
            this.setDescription(description.getText());
        }
        this.setKey(projectNode.selectSingleNode(KEY).getText());
        this.setLinks(new LinkedList<String>());
        this.setSubprojects(new LinkedList<Project>());
        this.setMostViolatedRules(new LinkedList<Rule>());
        this.setMostComplexFiles(new LinkedList<FileInfo>());
        this.setMostDuplicatedFiles(new LinkedList<FileInfo>());
        this.setMostViolatedFiles(new LinkedList<FileInfo>());
    }

    private void initMeasures(SonarAccess sonarAccess) throws IOException, DocumentException {
        Measures measures = new Measures();
        Logger.info("    Retrieving measures");
        measures.initMeasuresByProjectKey(sonarAccess, this.key);
        this.setMeasures(measures);
    }

    private void initMostViolatedRules(SonarAccess sonarAccess) throws IOException, DocumentException, ReportException {
        Logger.info("    Retrieving most violated rules");
        Logger.debug("Accessing Sonar: getting most violated rules");
        String[] priorities = Priority.getPrioritiesArray();
        int limit = 10;
        for (int i = priorities.length - 1; i >= 0 && limit > 0; --i) {
            Document mostViolatedRulesByLevel = sonarAccess.getUrlAsDocument("/api/resources?resource=" + this.key + "&depth=0" + UrlPath.getViolationsLevelPath(priorities[i]) + "&format=xml" + UrlPath.getLimit(limit));
            if (mostViolatedRulesByLevel.selectSingleNode(PROJECT) != null) {
                int count = this.initMostViolatedRulesFromNode(mostViolatedRulesByLevel.selectSingleNode(PROJECT), sonarAccess);
                Logger.debug("\t " + count + " " + priorities[i] + " violations");
                limit -= count;
                continue;
            }
            Logger.debug("There is not result on select //resources/resource");
            Logger.debug("There are no violations with level " + priorities[i]);
        }
    }

    private void initMostViolatedFiles(SonarAccess sonarAccess) throws IOException, DocumentException {
        Logger.info("    Retrieving most violated files");
        Logger.debug("Accessing Sonar: getting most violated files");
        Document mostViolatedFilesDoc = sonarAccess.getUrlAsDocument("/api/resources?resource=" + this.key + "&metrics=violations&scopes=FIL&depth=-1&limit=5" + "&format=xml");
        this.setMostViolatedFiles(FileInfo.initFromDocument(mostViolatedFilesDoc, 1));
    }

    private void initMostComplexElements(SonarAccess sonarAccess) throws IOException, DocumentException {
        Logger.info("    Retrieving most complex elements");
        Logger.debug("Accessing Sonar: getting most complex elements");
        Document mostComplexFilesDoc = sonarAccess.getUrlAsDocument("/api/resources?resource=" + this.key + "&metrics=complexity&scopes=FIL&depth=-1&limit=5" + "&format=xml");
        this.setMostComplexFiles(FileInfo.initFromDocument(mostComplexFilesDoc, 2));
    }

    private void initMostDuplicatedFiles(SonarAccess sonarAccess) throws IOException, DocumentException {
        Logger.info("    Retrieving most duplicated files");
        Logger.debug("Accessing Sonar: getting most duplicated files");
        Document mostDuplicatedFilesDoc = sonarAccess.getUrlAsDocument("/api/resources?resource=" + this.key + "&metrics=duplicated_lines&scopes=FIL&depth=-1&limit=5" + "&format=xml");
        this.setMostDuplicatedFiles(FileInfo.initFromDocument(mostDuplicatedFilesDoc, 3));
    }

    public Measure getMeasure(String measureKey) {
        if (this.measures.containsMeasure(measureKey)) {
            return this.measures.getMeasure(measureKey);
        }
        return new Measure(null, "N/A");
    }

    private int initMostViolatedRulesFromNode(Node mostViolatedNode, SonarAccess sonarAccess) throws ReportException, IOException, DocumentException {
        List measures = mostViolatedNode.selectNodes(ALL_MEASURES);
        Iterator it = measures.iterator();
        if (!it.hasNext()) {
            Logger.warn("There is not result on select //resources/resource/msr");
        }
        int count = 0;
        while (it.hasNext()) {
            Node measure = (Node)it.next();
            if (measure.selectSingleNode(MEASURE_FRMT_VAL).getText().equals("0")) continue;
            Rule rule = Rule.initFromNode(measure);
            if (PDFReporter.reportType.equals("workbook")) {
                rule.loadViolatedResources(sonarAccess, this.key);
            }
            this.mostViolatedRules.add(rule);
            ++count;
        }
        return count;
    }

    public Project getChildByKey(String key) {
        for (Project child : this.subprojects) {
            if (!child.getKey().equals(key)) continue;
            return child;
        }
        return null;
    }

    public void setId(short id) {
        this.id = id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLinks(List<String> links) {
        this.links = links;
    }

    public short getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getLinks() {
        return this.links;
    }

    public List<Project> getSubprojects() {
        return this.subprojects;
    }

    public void setSubprojects(List<Project> subprojects) {
        this.subprojects = subprojects;
    }

    public Measures getMeasures() {
        return this.measures;
    }

    public void setMeasures(Measures measures) {
        this.measures = measures;
    }

    public List<Rule> getMostViolatedRules() {
        return this.mostViolatedRules;
    }

    public List<FileInfo> getMostViolatedFiles() {
        return this.mostViolatedFiles;
    }

    public void setMostViolatedRules(List<Rule> mostViolatedRules) {
        this.mostViolatedRules = mostViolatedRules;
    }

    public void setMostViolatedFiles(List<FileInfo> mostViolatedFiles) {
        this.mostViolatedFiles = mostViolatedFiles;
    }

    public void setMostComplexFiles(List<FileInfo> mostComplexFiles) {
        this.mostComplexFiles = mostComplexFiles;
    }

    public List<FileInfo> getMostComplexFiles() {
        return this.mostComplexFiles;
    }

    public List<FileInfo> getMostDuplicatedFiles() {
        return this.mostDuplicatedFiles;
    }

    public void setMostDuplicatedFiles(List<FileInfo> mostDuplicatedFiles) {
        this.mostDuplicatedFiles = mostDuplicatedFiles;
    }
}

