/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.StreamFeeder;
import org.codehaus.plexus.util.cli.StreamPumper;

public abstract class CommandLineUtils {
    private static Map processes = Collections.synchronizedMap(new HashMap());

    public static int executeCommandLine(Commandline cl, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, null, systemOut, systemErr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCommandLine(Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        if (cl == null) {
            throw new IllegalArgumentException("cl cannot be null.");
        }
        Process p = cl.execute();
        processes.put(new Long(cl.getPid()), p);
        StreamFeeder inputFeeder = null;
        if (systemIn != null) {
            inputFeeder = new StreamFeeder(systemIn, p.getOutputStream());
        }
        StreamPumper outputPumper = new StreamPumper(p.getInputStream(), systemOut);
        StreamPumper errorPumper = new StreamPumper(p.getErrorStream(), systemErr);
        if (inputFeeder != null) {
            inputFeeder.start();
        }
        outputPumper.start();
        errorPumper.start();
        try {
            Thread thread;
            int returnValue = p.waitFor();
            if (inputFeeder != null) {
                thread = inputFeeder;
                synchronized (thread) {
                    if (!inputFeeder.isDone()) {
                        inputFeeder.wait();
                    }
                }
            }
            thread = outputPumper;
            synchronized (thread) {
                if (!outputPumper.isDone()) {
                    outputPumper.wait();
                }
            }
            thread = errorPumper;
            synchronized (thread) {
                if (!errorPumper.isDone()) {
                    errorPumper.wait();
                }
            }
            processes.remove(new Long(cl.getPid()));
            int n = returnValue;
            return n;
        }
        catch (InterruptedException ex) {
            CommandLineUtils.killProcess(cl.getPid());
            throw new CommandLineException("Error while executing external command, process killed.", ex);
        }
        finally {
            if (inputFeeder != null) {
                inputFeeder.close();
            }
            outputPumper.close();
            errorPumper.close();
        }
    }

    public static Properties getSystemEnvVars() throws IOException {
        return CommandLineUtils.getSystemEnvVars(true);
    }

    public static Properties getSystemEnvVars(boolean caseSensitive) throws IOException {
        String line;
        Process p = null;
        Properties envVars = new Properties();
        Runtime r = Runtime.getRuntime();
        String os = System.getProperty("os.name").toLowerCase();
        p = os.indexOf("windows") != -1 ? (os.indexOf("95") != -1 || os.indexOf("98") != -1 || os.indexOf("Me") != -1 ? r.exec("command.com /c set") : r.exec("cmd.exe /c set")) : r.exec("env");
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String lastKey = null;
        String lastVal = null;
        while ((line = br.readLine()) != null) {
            int idx = line.indexOf(61);
            if (idx > 1) {
                lastKey = line.substring(0, idx);
                if (!caseSensitive) {
                    lastKey = lastKey.toUpperCase();
                }
                lastVal = line.substring(idx + 1);
                envVars.setProperty(lastKey, lastVal);
                continue;
            }
            if (lastKey == null) continue;
            lastVal = lastVal + "\n" + line;
            envVars.setProperty(lastKey, lastVal);
        }
        return envVars;
    }

    public static void killProcess(long pid) {
        Process p = (Process)processes.get(new Long(pid));
        if (p != null) {
            p.destroy();
            System.out.println("killed.");
            processes.remove(new Long(pid));
        } else {
            System.out.println("don't exist.");
        }
    }

    public static boolean isAlive(long pid) {
        return processes.get(new Long(pid)) != null;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("CommandlineUtil shutdown"){

            public void run() {
                if (processes != null && processes.size() > 0) {
                    System.err.println("Destroying " + processes.size() + " processes");
                    Iterator it = processes.values().iterator();
                    while (it.hasNext()) {
                        System.err.println("Destroying process..");
                        ((Process)it.next()).destroy();
                    }
                    System.err.println("Destroyed " + processes.size() + " processes");
                }
            }
        });
    }

    public static class StringStreamConsumer
    implements StreamConsumer {
        private StringBuffer string = new StringBuffer();
        private String ls = System.getProperty("line.separator");

        public void consumeLine(String line) {
            this.string.append(line + this.ls);
        }

        public String getOutput() {
            return this.string.toString();
        }
    }
}

