/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.collections;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.component.collections.AbstractComponentCollection;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentMap<T>
extends AbstractComponentCollection<T>
implements Map<String, T> {
    private Map<String, T> components;
    private Map<String, T> customAdditions = new LinkedHashMap<String, T>();

    public ComponentMap(MutablePlexusContainer container, Class<T> type, String role, List<String> roleHints, String hostComponent) {
        super(container, type, role, roleHints, hostComponent);
    }

    @Override
    public int size() {
        return this.getComponentDescriptorMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getComponentDescriptorMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Map descriptorMap = this.getComponentDescriptorMap();
        return descriptorMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    @Override
    public T get(Object k) {
        return this.getMap().get(k);
    }

    @Override
    public T put(String key, T value) {
        this.logger.warn("Custom " + this.role + " implementations should NOT be added directly to this Map. Instead, add them as Plexus components.");
        T prev = this.customAdditions.put(key, value);
        if (prev == null) {
            prev = this.getComponentMap().get(key);
        }
        return prev;
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> map) {
        this.logger.warn("Custom " + this.role + " implementations should NOT be added directly to this Map. Instead, add them as Plexus components.");
        this.customAdditions.putAll(map);
    }

    @Override
    public Set<String> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public Collection<T> values() {
        return this.getMap().values();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.getMap().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map object = (Map)o;
        return ((Object)this.getMap()).equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.getMap()).hashCode();
    }

    @Override
    public T remove(Object k) {
        String key;
        this.logger.warn("Items in this Map should NOT be removed directly. If the matching entry is a component, it will NOT be removed.");
        if (k instanceof String && this.customAdditions.containsKey(key = (String)k)) {
            return this.customAdditions.remove(key);
        }
        return null;
    }

    private Map<String, T> getMap() {
        Map<String, T> result = this.getComponentMap();
        if (!this.customAdditions.isEmpty()) {
            result.putAll(this.customAdditions);
        }
        return result;
    }

    private Map<String, T> getComponentMap() {
        if (this.components == null || this.checkUpdate()) {
            LinkedHashMap<String, T> componentMap = new LinkedHashMap<String, T>();
            Map descriptorMap = this.getComponentDescriptorMap();
            if (this.roleHints != null) {
                for (String roleHint : this.roleHints) {
                    ComponentDescriptor componentDescriptor = descriptorMap.get(roleHint);
                    Object component = this.lookup(componentDescriptor);
                    if (component == null) continue;
                    componentMap.put(roleHint, component);
                }
            } else {
                for (Map.Entry entry : descriptorMap.entrySet()) {
                    String roleHint = entry.getKey();
                    ComponentDescriptor componentDescriptor = entry.getValue();
                    Object component = this.lookup(componentDescriptor);
                    if (component == null) continue;
                    componentMap.put(roleHint, component);
                }
            }
            this.components = componentMap;
        }
        return this.components;
    }

    @Override
    protected boolean checkUpdate() {
        if (super.checkUpdate()) {
            this.components = null;
            return true;
        }
        return false;
    }

    @Override
    protected void releaseAllCallback() {
        if (this.components != null) {
            try {
                this.container.releaseAll(this.components);
            }
            catch (ComponentLifecycleException e) {
                this.logger.debug("Error releasing components in active collection: " + e.getMessage(), e);
            }
            this.components.clear();
            this.components = null;
        }
    }
}

