/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.container.initialization;

import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.container.initialization.AbstractContainerInitializationPhase;
import org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.codehaus.plexus.container.initialization.ContainerInitializationException;

public class StartLoadOnStartComponentsPhase
extends AbstractContainerInitializationPhase {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ContainerInitializationContext context) throws ContainerInitializationException {
        PlexusConfiguration[] loadOnStartComponents = context.getContainer().getConfiguration().getChild("load-on-start").getChildren("component");
        context.getContainer().getLogger().debug("Found " + loadOnStartComponents.length + " components to load on start");
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)context.getContainerRealm());
        try {
            try {
                int i = 0;
                while (i < loadOnStartComponents.length) {
                    String role = loadOnStartComponents[i].getChild("role").getValue(null);
                    String roleHint = loadOnStartComponents[i].getChild("role-hint").getValue(null);
                    if (role == null) {
                        throw new ContainerInitializationException("Missing 'role' element from load-on-start.");
                    }
                    if (roleHint == null) {
                        roleHint = "default";
                    }
                    if (roleHint.equals("*")) {
                        context.getContainer().getLogger().info("Loading on start all components with [role]: [" + role + "]");
                        context.getContainer().lookupList(role);
                    } else {
                        context.getContainer().getLogger().info("Loading on start [role,roleHint]: [" + role + "," + roleHint + "]");
                        context.getContainer().lookup(role, roleHint);
                    }
                    ++i;
                }
            }
            catch (ComponentLookupException e) {
                throw new ContainerInitializationException("Error looking up load-on-start component.", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            Thread.currentThread().setContextClassLoader(prevCl);
            throw throwable;
        }
        {
            Object var7_10 = null;
            Thread.currentThread().setContextClassLoader(prevCl);
            return;
        }
    }
}

