/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.metadata.ComponentDescriptorExtractor;
import org.codehaus.plexus.metadata.ComponentDescriptorWriter;
import org.codehaus.plexus.metadata.DefaultComponentDescriptorWriter;
import org.codehaus.plexus.metadata.MetadataGenerationRequest;
import org.codehaus.plexus.metadata.MetadataGenerator;
import org.codehaus.plexus.metadata.merge.Merger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

@Component(role=MetadataGenerator.class)
public class DefaultMetadataGenerator
extends AbstractLogEnabled
implements MetadataGenerator {
    @Requirement
    private Merger merger;
    private ComponentDescriptor<?>[] roleDefaults;
    @Requirement
    private Map<String, ComponentDescriptorExtractor> extractorMap;
    private ComponentDescriptorWriter writer = new DefaultComponentDescriptorWriter();

    @Override
    public void generateDescriptor(MetadataGenerationRequest request) throws Exception {
        Collection<ComponentDescriptorExtractor> extractors;
        assert (request.outputFile != null);
        List<String> extractorHints = request.extractors;
        if (extractorHints == null || extractorHints.size() == 0) {
            extractors = this.extractorMap.values();
        } else {
            extractors = new ArrayList<ComponentDescriptorExtractor>(extractorHints.size());
            for (String string : extractorHints) {
                extractors.add(this.extractorMap.get(string));
            }
        }
        ArrayList descriptors = new ArrayList();
        for (ComponentDescriptorExtractor extractor : extractors) {
            try {
                List<ComponentDescriptor<?>> list = extractor.extract(request, this.roleDefaults);
                if (list == null || list.isEmpty()) continue;
                descriptors.addAll(list);
            }
            catch (Exception e) {
                throw new Exception("Failed to extract descriptors", e);
            }
        }
        Collections.sort(descriptors, new Comparator<ComponentDescriptor>(){

            @Override
            public int compare(ComponentDescriptor d1, ComponentDescriptor d2) {
                return d1.getHumanReadableKey().compareTo(d2.getHumanReadableKey());
            }
        });
        ArrayList<File> arrayList = new ArrayList<File>();
        if (descriptors.size() > 0) {
            this.getLogger().info("Discovered " + descriptors.size() + " component descriptors(s)");
            ComponentSetDescriptor set = new ComponentSetDescriptor();
            set.setComponents(descriptors);
            set.setDependencies(Collections.emptyList());
            if (request.componentDescriptorDirectory == null) {
                this.writeDescriptor(set, request.outputFile);
            } else {
                if (request.intermediaryFile == null) {
                    request.intermediaryFile = File.createTempFile("plexus-metadata", "xml");
                    request.intermediaryFile.deleteOnExit();
                }
                this.writeDescriptor(set, request.intermediaryFile);
                arrayList.add(request.intermediaryFile);
            }
        }
        if (request.componentDescriptorDirectory != null && request.componentDescriptorDirectory.isDirectory()) {
            File[] files = request.componentDescriptorDirectory.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return f1.getName().compareTo(f2.getName());
                }
            });
            int added = 0;
            for (File file : files) {
                if (!file.getName().endsWith(".xml") || file.getName().equals("plexus.xml")) continue;
                arrayList.add(file);
                ++added;
            }
            this.getLogger().info("Merging " + added + " manually-crafted descriptor file(s)");
        }
        if (arrayList.size() > 0) {
            this.merger.mergeDescriptors(request.outputFile, arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDescriptor(ComponentSetDescriptor desc, File outputFile) throws Exception {
        assert (desc != null);
        assert (outputFile != null);
        FileUtils.forceMkdir((File)outputFile.getParentFile());
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
        try {
            this.writer.writeDescriptorSet(output, desc, false);
            output.flush();
        }
        finally {
            IOUtil.close((Writer)output);
        }
        this.getLogger().debug("Wrote: " + outputFile);
    }
}

