/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata.ann;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.metadata.ann.Ann;
import org.codehaus.plexus.metadata.ann.AnnField;
import org.codehaus.plexus.metadata.ann.AnnMethod;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnClass {
    private int access;
    private String name;
    private String superName;
    private String[] interfaces;
    private Map<String, Ann> anns = new LinkedHashMap<String, Ann>();
    private Map<String, AnnField> fields = new LinkedHashMap<String, AnnField>();
    private Map<String, AnnMethod> methods = new LinkedHashMap<String, AnnMethod>();
    private ClassLoader cl;

    public AnnClass(ClassLoader cl) {
        this.cl = cl;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public void setSuperName(String superName) {
        this.superName = superName;
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public void addAnn(Ann ann) {
        this.anns.put(ann.getDesc(), ann);
    }

    public void addField(AnnField field) {
        this.fields.put(field.getName(), field);
    }

    public void addMethod(AnnMethod method) {
        this.methods.put(method.getName() + method.getDesc(), method);
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getSuperName() {
        return this.superName;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public Map<String, Ann> getAnns() {
        return this.anns;
    }

    public Map<String, AnnField> getFields() {
        return this.fields;
    }

    public Map<String, AnnMethod> getMethods() {
        return this.methods;
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    public Set<String> getMethodKeys() {
        return this.methods.keySet();
    }

    public <T> T getAnnotation(Class<T> c) {
        Ann ann = this.anns.get(Type.getDescriptor(c));
        return ann == null ? null : (T)ann.getAnnotation(c, this.cl);
    }

    public <T> T getFieldAnnotation(String fieldName, Class<T> c) {
        AnnField field = this.fields.get(fieldName);
        return field == null ? null : (T)field.getAnnotation(c);
    }

    public <T> T getMethodAnnotation(String methodKey, Class<T> c) {
        AnnMethod method = this.methods.get(methodKey);
        return method == null ? null : (T)method.getAnnotation(c);
    }
}

