/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.deployment.ant.pack200;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipFile;
import org.apache.tools.ant.util.FileUtils;

public class PackUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pack(File source, File destination, Map props, boolean gzip) throws IOException {
        ZipFile jar = null;
        OutputStream out = null;
        try {
            out = new FileOutputStream(destination);
            if (gzip) {
                out = new GZIPOutputStream(out){
                    {
                        this.def.setLevel(9);
                    }
                };
            }
            out = new BufferedOutputStream(out);
            jar = new JarFile(source, false);
            Pack200.Packer packer = Pack200.newPacker();
            packer.properties().putAll(props);
            packer.pack((JarFile)jar, out);
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            if (jar != null) {
                jar.close();
            }
            throw throwable;
        }
        FileUtils.close((OutputStream)out);
        if (jar != null) {
            jar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void repack(File source, File destination, Map props) throws IOException {
        File tempFile = new File(source.toString() + ".tmp");
        try {
            PackUtils.pack(source, tempFile, props, false);
            PackUtils.unpack(tempFile, destination, props);
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpack(File source, File destination, Map props) throws IOException {
        InputStream in = null;
        JarOutputStream out = null;
        try {
            in = new FileInputStream(source);
            if (PackUtils.isGzipped(source)) {
                in = new GZIPInputStream(in);
            }
            in = new BufferedInputStream(in);
            out = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(destination)));
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            unpacker.properties().putAll(props);
            unpacker.unpack(in, out);
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close((InputStream)in);
        FileUtils.close((OutputStream)out);
    }

    private static boolean isGzipped(File file) throws IOException {
        DataInputStream is = new DataInputStream(new FileInputStream(file));
        int i = is.readInt();
        is.close();
        return (i & 0xFFFFFF00) == 529205248;
    }
}

