/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PluginUpdatesDetails;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.PropertyVersionsBuilder;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.model.IgnoreVersion;
import org.codehaus.mojo.versions.model.Rule;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.model.io.xpp3.RuleXpp3Reader;
import org.codehaus.mojo.versions.ordering.VersionComparator;
import org.codehaus.mojo.versions.ordering.VersionComparators;
import org.codehaus.mojo.versions.utils.DefaultArtifactVersionCache;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.mojo.versions.utils.RegexUtils;
import org.codehaus.mojo.versions.utils.VersionsExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;

public class DefaultVersionsHelper
implements VersionsHelper {
    private static final String CLASSPATH_PROTOCOL = "classpath";
    private static final String TYPE_EXACT = "exact";
    private static final String TYPE_REGEX = "regex";
    private static final int LOOKUP_PARALLEL_THREADS = 5;
    private RuleSet ruleSet;
    private final RepositorySystem repositorySystem;
    private final org.eclipse.aether.RepositorySystem aetherRepositorySystem;
    private final Log log;
    private final MavenSession mavenSession;
    private final MojoExecution mojoExecution;
    private final Map<String, Rule> artifactBestFitRule = new HashMap<String, Rule>();
    private final List<RemoteRepository> remoteProjectRepositories;
    private final List<RemoteRepository> remotePluginRepositories;
    private final List<RemoteRepository> remoteRepositories;

    private DefaultVersionsHelper(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, MavenSession mavenSession, MojoExecution mojoExecution, Log log) {
        this.repositorySystem = repositorySystem;
        this.aetherRepositorySystem = aetherRepositorySystem;
        this.mavenSession = mavenSession;
        this.mojoExecution = mojoExecution;
        this.log = log;
        this.remoteProjectRepositories = Optional.ofNullable(mavenSession).map(MavenSession::getCurrentProject).map(MavenProject::getRemoteProjectRepositories).map(DefaultVersionsHelper::adjustRemoteRepositoriesRefreshPolicy).orElseGet(Collections::emptyList);
        this.remotePluginRepositories = Optional.ofNullable(mavenSession).map(MavenSession::getCurrentProject).map(MavenProject::getRemotePluginRepositories).map(DefaultVersionsHelper::adjustRemoteRepositoriesRefreshPolicy).orElseGet(Collections::emptyList);
        this.remoteRepositories = Stream.concat(this.remoteProjectRepositories.stream(), this.remotePluginRepositories.stream()).distinct().collect(Collectors.toList());
    }

    static List<RemoteRepository> adjustRemoteRepositoriesRefreshPolicy(List<RemoteRepository> remoteRepositories) {
        return remoteRepositories.stream().map(DefaultVersionsHelper::adjustRemoteRepositoryRefreshPolicy).collect(Collectors.toList());
    }

    static RemoteRepository adjustRemoteRepositoryRefreshPolicy(RemoteRepository remoteRepository) {
        RepositoryPolicy snapshotPolicy = remoteRepository.getPolicy(true);
        RepositoryPolicy releasePolicy = remoteRepository.getPolicy(false);
        RepositoryPolicy newSnapshotPolicy = null;
        RepositoryPolicy newReleasePolicy = null;
        if (snapshotPolicy.isEnabled() && "never".equals(snapshotPolicy.getUpdatePolicy())) {
            newSnapshotPolicy = new RepositoryPolicy(true, "daily", snapshotPolicy.getChecksumPolicy());
        }
        if (releasePolicy.isEnabled() && "never".equals(releasePolicy.getUpdatePolicy())) {
            newReleasePolicy = new RepositoryPolicy(true, "daily", releasePolicy.getChecksumPolicy());
        }
        if (newSnapshotPolicy != null || newReleasePolicy != null) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(remoteRepository);
            if (newSnapshotPolicy != null) {
                builder.setSnapshotPolicy(newSnapshotPolicy);
            }
            if (newReleasePolicy != null) {
                builder.setReleasePolicy(newReleasePolicy);
            }
            return builder.build();
        }
        return remoteRepository;
    }

    static boolean exactMatch(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, true));
        return p.matcher(value).matches();
    }

    static boolean match(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, false));
        return p.matcher(value).matches();
    }

    static boolean isClasspathUri(String uri) {
        return uri != null && uri.startsWith("classpath:");
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public ArtifactVersions lookupArtifactVersions(Artifact artifact, VersionRange versionRange, boolean usePluginRepositories) throws VersionRetrievalException {
        return this.lookupArtifactVersions(artifact, versionRange, usePluginRepositories, !usePluginRepositories);
    }

    @Override
    public ArtifactVersions lookupArtifactVersions(Artifact artifact, VersionRange versionRange, boolean usePluginRepositories, boolean useProjectRepositories) throws VersionRetrievalException {
        try {
            List<IgnoreVersion> ignoredVersions = this.getIgnoredVersions(artifact);
            if (!ignoredVersions.isEmpty() && this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found ignored versions: " + ignoredVersions.stream().map(IgnoreVersion::toString).collect(Collectors.joining(", "))));
            }
            List<Object> repositories = usePluginRepositories && !useProjectRepositories ? this.remotePluginRepositories : (!usePluginRepositories && useProjectRepositories ? this.remoteProjectRepositories : (usePluginRepositories ? this.remoteRepositories : Collections.emptyList()));
            return new ArtifactVersions(artifact, this.aetherRepositorySystem.resolveVersionRange(this.mavenSession.getRepositorySession(), new VersionRangeRequest(RepositoryUtils.toArtifact((Artifact)artifact).setVersion(Optional.ofNullable(versionRange).map(VersionRange::getRestrictions).flatMap(list -> list.stream().findFirst().map(Restriction::toString)).orElse("(,)")), repositories, "lookupArtifactVersions")).getVersions().stream().filter(v -> ignoredVersions.stream().noneMatch(i -> {
                if (TYPE_REGEX.equals(i.getType()) && Pattern.compile(i.getVersion()).matcher(v.toString()).matches()) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Version " + v + " for artifact " + ArtifactUtils.versionlessKey((Artifact)artifact) + " found on ignore list: " + i));
                    }
                    return true;
                }
                if (TYPE_EXACT.equals(i.getType()) && i.getVersion().equals(v.toString())) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Version " + v + " for artifact " + ArtifactUtils.versionlessKey((Artifact)artifact) + " found on ignore list: " + i));
                    }
                    return true;
                }
                return false;
            })).map(v -> DefaultArtifactVersionCache.of(v.toString())).collect(Collectors.toList()), this.getVersionComparator(artifact));
        }
        catch (VersionRangeResolutionException e) {
            throw new VersionRetrievalException(e.getMessage(), e);
        }
    }

    @Override
    public ArtifactVersions lookupArtifactVersions(Artifact artifact, boolean usePluginRepositories) throws VersionRetrievalException {
        return this.lookupArtifactVersions(artifact, null, usePluginRepositories);
    }

    private List<IgnoreVersion> getIgnoredVersions(Artifact artifact) {
        ArrayList<IgnoreVersion> ret = new ArrayList<IgnoreVersion>();
        for (IgnoreVersion ignoreVersion : this.ruleSet.getIgnoreVersions()) {
            if (!TYPE_EXACT.equals(ignoreVersion.getType()) && !TYPE_REGEX.equals(ignoreVersion.getType())) {
                this.getLog().warn((CharSequence)("The type attribute '" + ignoreVersion.getType() + "' for global ignoreVersion[" + ignoreVersion + "] is not valid. Please use either '" + TYPE_EXACT + "' or '" + TYPE_REGEX + "'."));
                continue;
            }
            ret.add(ignoreVersion);
        }
        Rule rule = this.getBestFitRule(artifact.getGroupId(), artifact.getArtifactId());
        if (rule != null) {
            for (IgnoreVersion ignoreVersion : rule.getIgnoreVersions()) {
                if (!TYPE_EXACT.equals(ignoreVersion.getType()) && !TYPE_REGEX.equals(ignoreVersion.getType())) {
                    this.getLog().warn((CharSequence)("The type attribute '" + ignoreVersion.getType() + "' for " + rule + " is not valid. Please use either '" + TYPE_EXACT + "' or '" + TYPE_REGEX + "'."));
                    continue;
                }
                ret.add(ignoreVersion);
            }
        }
        return ret;
    }

    @Override
    public void resolveArtifact(Artifact artifact, boolean usePluginRepositories) throws ArtifactResolutionException {
        try {
            ArtifactResult artifactResult = this.aetherRepositorySystem.resolveArtifact(this.mavenSession.getRepositorySession(), new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), usePluginRepositories ? this.mavenSession.getCurrentProject().getRemotePluginRepositories() : this.mavenSession.getCurrentProject().getRemoteProjectRepositories(), this.getClass().getName()));
            artifact.setFile(artifactResult.getArtifact().getFile());
            artifact.setVersion(artifactResult.getArtifact().getVersion());
            artifact.setResolved(artifactResult.isResolved());
        }
        catch (org.eclipse.aether.resolution.ArtifactResolutionException e) {
            throw new ArtifactResolutionException(e.getMessage(), artifact);
        }
    }

    @Override
    public VersionComparator getVersionComparator(Artifact artifact) {
        return this.getVersionComparator(artifact.getGroupId(), artifact.getArtifactId());
    }

    @Override
    public VersionComparator getVersionComparator(String groupId, String artifactId) {
        Rule rule = this.getBestFitRule(groupId, artifactId);
        String comparisonMethod = rule == null ? this.ruleSet.getComparisonMethod() : rule.getComparisonMethod();
        return VersionComparators.getVersionComparator(comparisonMethod);
    }

    protected Rule getBestFitRule(String groupId, String artifactId) {
        String groupArtifactId = groupId + ':' + artifactId;
        if (this.artifactBestFitRule.containsKey(groupArtifactId)) {
            return this.artifactBestFitRule.get(groupArtifactId);
        }
        Rule bestFit = null;
        List rules = this.ruleSet.getRules();
        int bestGroupIdScore = Integer.MAX_VALUE;
        int bestArtifactIdScore = Integer.MAX_VALUE;
        boolean exactGroupId = false;
        boolean exactArtifactId = false;
        for (Rule rule : rules) {
            int artifactIdScore;
            boolean exactMatch;
            boolean match;
            int groupIdScore = RegexUtils.getWildcardScore(rule.getGroupId());
            if (groupIdScore > bestGroupIdScore || !(match = (exactMatch = DefaultVersionsHelper.exactMatch(rule.getGroupId(), groupId)) || DefaultVersionsHelper.match(rule.getGroupId(), groupId)) || exactGroupId && !exactMatch) continue;
            if (bestGroupIdScore > groupIdScore) {
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            bestGroupIdScore = groupIdScore;
            if (exactMatch && !exactGroupId) {
                exactGroupId = true;
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            if ((artifactIdScore = RegexUtils.getWildcardScore(rule.getArtifactId())) > bestArtifactIdScore || !(match = (exactMatch = DefaultVersionsHelper.exactMatch(rule.getArtifactId(), artifactId)) || DefaultVersionsHelper.match(rule.getArtifactId(), artifactId)) || exactArtifactId && !exactMatch) continue;
            bestArtifactIdScore = artifactIdScore;
            if (exactMatch && !exactArtifactId) {
                exactArtifactId = true;
            }
            bestFit = rule;
        }
        this.artifactBestFitRule.put(groupArtifactId, bestFit);
        return bestFit;
    }

    @Override
    public Artifact createPluginArtifact(String groupId, String artifactId, String version) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(groupId);
        plugin.setArtifactId(artifactId);
        plugin.setVersion(StringUtils.isNotBlank((String)version) ? version : "[0,]");
        return this.repositorySystem.createPluginArtifact(plugin);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, String version, String type, String classifier, String scope, boolean optional) {
        return this.repositorySystem.createDependencyArtifact(DependencyBuilder.newBuilder().withGroupId(groupId).withArtifactId(artifactId).withType(type).withClassifier(classifier).withScope(scope).withOptional(optional).withVersion(StringUtils.isNotBlank((String)version) ? version : "[0,]").build());
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, String version, String type, String classifier, String scope) {
        return this.createDependencyArtifact(groupId, artifactId, version, type, classifier, scope, false);
    }

    @Override
    public Artifact createDependencyArtifact(Dependency dependency) {
        if (StringUtils.isBlank((String)dependency.getVersion())) {
            dependency = dependency.clone();
            dependency.setVersion("[,0]");
        }
        return this.repositorySystem.createDependencyArtifact(dependency);
    }

    @Override
    public Set<Artifact> extractArtifacts(Collection<MavenProject> mavenProjects) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (MavenProject project : mavenProjects) {
            result.add(project.getArtifact());
        }
        return result;
    }

    @Override
    public ArtifactVersion createArtifactVersion(String version) {
        return DefaultArtifactVersionCache.of(version);
    }

    @Override
    public Map<Dependency, ArtifactVersions> lookupDependenciesUpdates(Stream<Dependency> dependencies, boolean usePluginRepositories, boolean useProjectRepositories, boolean allowSnapshots) throws VersionRetrievalException {
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            TreeMap<Dependency, ArtifactVersions> dependencyUpdates = new TreeMap<Dependency, ArtifactVersions>(DependencyComparator.INSTANCE);
            List futures = dependencies.map(dependency -> executor.submit(() -> new ImmutablePair(dependency, (Object)this.lookupDependencyUpdates((Dependency)dependency, usePluginRepositories, useProjectRepositories, allowSnapshots)))).collect(Collectors.toList());
            for (Future details : futures) {
                Pair pair = (Pair)details.get();
                dependencyUpdates.put((Dependency)pair.getKey(), (ArtifactVersions)pair.getValue());
            }
            TreeMap<Dependency, ArtifactVersions> treeMap = dependencyUpdates;
            return treeMap;
        }
        catch (InterruptedException | ExecutionException ie) {
            throw new VersionRetrievalException("Unable to acquire metadata for dependencies " + dependencies + ": " + ie.getMessage(), ie);
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public Map<Dependency, ArtifactVersions> lookupDependenciesUpdates(Stream<Dependency> dependencies, boolean usePluginRepositories, boolean allowSnapshots) throws VersionRetrievalException {
        return this.lookupDependenciesUpdates(dependencies, usePluginRepositories, !usePluginRepositories, allowSnapshots);
    }

    @Override
    public ArtifactVersions lookupDependencyUpdates(Dependency dependency, boolean usePluginRepositories, boolean useProjectRepositories, boolean allowSnapshots) throws VersionRetrievalException {
        ArtifactVersions allVersions = this.lookupArtifactVersions(this.createDependencyArtifact(dependency), null, usePluginRepositories, useProjectRepositories);
        return new ArtifactVersions(allVersions.getArtifact(), Arrays.stream(allVersions.getAllUpdates(allowSnapshots)).collect(Collectors.toList()), allVersions.getVersionComparator());
    }

    @Override
    public Map<Plugin, PluginUpdatesDetails> lookupPluginsUpdates(Stream<Plugin> plugins, boolean allowSnapshots) throws VersionRetrievalException {
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            TreeMap<Object, PluginUpdatesDetails> pluginUpdates = new TreeMap<Object, PluginUpdatesDetails>(PluginComparator.INSTANCE);
            List futures = plugins.map(p -> executor.submit(() -> new ImmutablePair(p, (Object)this.lookupPluginUpdates((Plugin)p, allowSnapshots)))).collect(Collectors.toList());
            for (Future details : futures) {
                Pair pair = (Pair)details.get();
                pluginUpdates.put((Plugin)pair.getKey(), (PluginUpdatesDetails)pair.getValue());
            }
            TreeMap<Object, PluginUpdatesDetails> treeMap = pluginUpdates;
            return treeMap;
        }
        catch (InterruptedException | ExecutionException ie) {
            throw new VersionRetrievalException("Unable to acquire metadata for plugins " + plugins + ": " + ie.getMessage(), ie);
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public PluginUpdatesDetails lookupPluginUpdates(Plugin plugin, boolean allowSnapshots) throws VersionRetrievalException {
        String version = plugin.getVersion() != null ? plugin.getVersion() : "LATEST";
        TreeSet<Dependency> pluginDependencies = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        if (plugin.getDependencies() != null) {
            pluginDependencies.addAll(plugin.getDependencies());
        }
        Map<Dependency, ArtifactVersions> pluginDependencyDetails = this.lookupDependenciesUpdates(pluginDependencies.stream(), false, allowSnapshots);
        ArtifactVersions allVersions = this.lookupArtifactVersions(this.createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), version), true);
        ArtifactVersions updatedVersions = new ArtifactVersions(allVersions.getArtifact(), Arrays.stream(allVersions.getAllUpdates(allowSnapshots)).collect(Collectors.toList()), allVersions.getVersionComparator());
        return new PluginUpdatesDetails(updatedVersions, pluginDependencyDetails, allowSnapshots);
    }

    @Override
    public ExpressionEvaluator getExpressionEvaluator(MavenProject project) {
        return new VersionsExpressionEvaluator(this.mavenSession, this.mojoExecution);
    }

    @Override
    public Map<Property, PropertyVersions> getVersionPropertiesMap(VersionsHelper.VersionPropertiesMapRequest request) throws MojoExecutionException {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        if (request.getPropertyDefinitions() != null) {
            Arrays.stream(request.getPropertyDefinitions()).forEach(p -> properties.put(p.getName(), (Property)p));
        }
        HashMap<String, PropertyVersionsBuilder> builders = new HashMap<String, PropertyVersionsBuilder>();
        if (request.isAutoLinkItems()) {
            PropertyVersionsBuilder[] propertyVersionsBuilders;
            try {
                propertyVersionsBuilders = PomHelper.getPropertyVersionsBuilders(this, request.getMavenProject(), request.isIncludeParent());
            }
            catch (IOException | ExpressionEvaluationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            for (PropertyVersionsBuilder propertyVersionsBuilder : propertyVersionsBuilders) {
                String name = propertyVersionsBuilder.getName();
                builders.put(name, propertyVersionsBuilder);
                if (properties.containsKey(name)) continue;
                Property value = new Property(name);
                this.getLog().debug((CharSequence)("Property ${" + name + "}: Adding inferred version range of " + propertyVersionsBuilder.getVersionRange()));
                value.setVersion(propertyVersionsBuilder.getVersionRange());
                properties.put(name, value);
            }
        }
        List includePropertiesList = request.getIncludeProperties() != null ? Arrays.asList(request.getIncludeProperties().split("\\s*,\\s*")) : Collections.emptyList();
        List excludePropertiesList = request.getExcludeProperties() != null ? Arrays.asList(request.getExcludeProperties().split("\\s*,\\s*")) : Collections.emptyList();
        this.getLog().debug((CharSequence)"Searching for properties associated with builders");
        Iterator i = properties.values().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            this.getLog().debug((CharSequence)("includePropertiesList:" + includePropertiesList + " property: " + property.getName()));
            this.getLog().debug((CharSequence)("excludePropertiesList:" + excludePropertiesList + " property: " + property.getName()));
            if (!includePropertiesList.isEmpty() && !includePropertiesList.contains(property.getName())) {
                this.getLog().debug((CharSequence)("Skipping property ${" + property.getName() + "}"));
                i.remove();
                continue;
            }
            if (excludePropertiesList.isEmpty() || !excludePropertiesList.contains(property.getName())) continue;
            this.getLog().debug((CharSequence)("Ignoring property ${" + property.getName() + "}"));
            i.remove();
        }
        i = properties.values().iterator();
        LinkedHashMap<Property, PropertyVersions> propertyVersions = new LinkedHashMap<Property, PropertyVersions>(properties.size());
        while (i.hasNext()) {
            Dependency[] dependencies;
            Property property = (Property)i.next();
            this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}"));
            PropertyVersionsBuilder builder = (PropertyVersionsBuilder)builders.get(property.getName());
            if (builder == null || !builder.isAssociated()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Looks like this property is not associated with any dependency..."));
                builder = new PropertyVersionsBuilder(null, property.getName(), this);
            }
            if (!property.isAutoLinkDependencies()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Removing any autoLinkDependencies"));
                builder.clearAssociations();
            }
            if ((dependencies = property.getDependencies()) != null) {
                for (Dependency dependency : dependencies) {
                    this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Adding association to " + dependency));
                    builder.withAssociation(this.createDependencyArtifact(dependency), false);
                }
            }
            try {
                if (property.isAutoLinkDependencies() && StringUtils.isEmpty((String)property.getVersion()) && !StringUtils.isEmpty((String)builder.getVersionRange())) {
                    this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Adding inferred version range of " + builder.getVersionRange()));
                    property.setVersion(builder.getVersionRange());
                }
                String currentVersion = request.getMavenProject().getProperties().getProperty(property.getName());
                property.setValue(currentVersion);
                try {
                    if (currentVersion != null) {
                        builder.withCurrentVersion((ArtifactVersion)DefaultArtifactVersionCache.of(currentVersion)).withCurrentVersionRange(VersionRange.createFromVersionSpec((String)currentVersion));
                    }
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new RuntimeException(e);
                }
                PropertyVersions versions = builder.build();
                propertyVersions.put(property, versions);
            }
            catch (VersionRetrievalException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        return propertyVersions;
    }

    public static class Builder {
        private RepositorySystem repositorySystem;
        private Collection<String> ignoredVersions;
        private RuleSet ruleSet;
        private String serverId;
        private String rulesUri;
        private Log log;
        private MavenSession mavenSession;
        private MojoExecution mojoExecution;
        private org.eclipse.aether.RepositorySystem aetherRepositorySystem;
        private Map<String, Wagon> wagonMap;

        private static RuleSet getRulesFromClasspath(String uri, Log logger) throws MojoExecutionException {
            RuleSet ruleSet;
            logger.debug((CharSequence)("Going to load rules from \"" + uri + "\""));
            String choppedUrl = uri.substring(DefaultVersionsHelper.CLASSPATH_PROTOCOL.length() + 3);
            URL url = DefaultVersionsHelper.class.getResource(choppedUrl);
            if (url == null) {
                throw new MojoExecutionException("Resource \"" + uri + "\" not found in classpath.");
            }
            BufferedInputStream bis = new BufferedInputStream(url.openStream());
            try {
                RuleSet result = new RuleXpp3Reader().read((InputStream)bis);
                logger.debug((CharSequence)("Loaded rules from \"" + uri + "\" successfully"));
                ruleSet = result;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException e) {
                    throw new MojoExecutionException("Could not load specified rules from " + uri, (Exception)e);
                }
            }
            bis.close();
            return ruleSet;
        }

        private static RuleSet enrichRuleSet(Collection<String> ignoredVersions, RuleSet originalRuleSet) {
            RuleSet ruleSet = new RuleSet();
            if (originalRuleSet != null) {
                ruleSet.setComparisonMethod(originalRuleSet.getComparisonMethod());
                if (originalRuleSet.getRules() != null) {
                    ruleSet.setRules(new ArrayList(originalRuleSet.getRules()));
                }
                if (originalRuleSet.getIgnoreVersions() != null) {
                    ruleSet.setIgnoreVersions(new ArrayList(originalRuleSet.getIgnoreVersions()));
                }
            }
            if (ruleSet.getIgnoreVersions() == null) {
                ruleSet.setIgnoreVersions(new ArrayList());
            }
            ruleSet.getIgnoreVersions().addAll(ignoredVersions.stream().map(v -> {
                IgnoreVersion ignoreVersion = new IgnoreVersion();
                ignoreVersion.setType(DefaultVersionsHelper.TYPE_REGEX);
                ignoreVersion.setVersion(v);
                return ignoreVersion;
            }).collect(Collectors.toList()));
            return ruleSet;
        }

        private RemoteRepository remoteRepository(RulesUri uri) {
            RemoteRepository prototype = new RemoteRepository.Builder(this.serverId, null, uri.basePath).build();
            RemoteRepository.Builder builder = new RemoteRepository.Builder(prototype);
            Optional.ofNullable(this.mavenSession.getRepositorySession().getProxySelector().getProxy(prototype)).ifPresent(arg_0 -> ((RemoteRepository.Builder)builder).setProxy(arg_0));
            Optional.ofNullable(this.mavenSession.getRepositorySession().getAuthenticationSelector().getAuthentication(prototype)).ifPresent(arg_0 -> ((RemoteRepository.Builder)builder).setAuthentication(arg_0));
            Optional.ofNullable(this.mavenSession.getRepositorySession().getMirrorSelector().getMirror(prototype)).ifPresent(mirror -> builder.setMirroredRepositories(Collections.singletonList(mirror)));
            return builder.build();
        }

        private Optional<ProxyInfo> getProxyInfo(RemoteRepository repository) {
            return Optional.ofNullable(repository.getProxy()).map(proxy -> new ProxyInfo((Proxy)proxy, repository){
                final /* synthetic */ Proxy val$proxy;
                final /* synthetic */ RemoteRepository val$repository;
                {
                    this.val$proxy = proxy;
                    this.val$repository = remoteRepository;
                    this.setHost(this.val$proxy.getHost());
                    this.setPort(this.val$proxy.getPort());
                    this.setType(this.val$proxy.getType());
                    Optional.ofNullable(this.val$proxy.getAuthentication()).ifPresent(auth -> {
                        try (AuthenticationContext authCtx = AuthenticationContext.forProxy((RepositorySystemSession)mavenSession.getRepositorySession(), (RemoteRepository)this.val$repository);){
                            Optional.ofNullable(authCtx.get("username")).ifPresent(arg_0 -> (this).setUserName(arg_0));
                            Optional.ofNullable(authCtx.get("password")).ifPresent(arg_0 -> (this).setPassword(arg_0));
                            Optional.ofNullable(authCtx.get("ntlm.domain")).ifPresent(arg_0 -> (this).setNtlmDomain(arg_0));
                            Optional.ofNullable(authCtx.get("ntlm.workstation")).ifPresent(arg_0 -> (this).setNtlmHost(arg_0));
                        }
                    });
                }
            });
        }

        private Optional<AuthenticationInfo> getAuthenticationInfo(final RemoteRepository repository) {
            return Optional.ofNullable(repository.getAuthentication()).map(authentication -> new AuthenticationInfo(){
                {
                    try (AuthenticationContext authCtx = AuthenticationContext.forRepository((RepositorySystemSession)mavenSession.getRepositorySession(), (RemoteRepository)repository);){
                        Optional.ofNullable(authCtx.get("username")).ifPresent(arg_0 -> (this).setUserName(arg_0));
                        Optional.ofNullable(authCtx.get("password")).ifPresent(arg_0 -> (this).setPassword(arg_0));
                        Optional.ofNullable(authCtx.get("privateKey.passphrase")).ifPresent(arg_0 -> (this).setPassphrase(arg_0));
                        Optional.ofNullable(authCtx.get("privateKey.path")).ifPresent(arg_0 -> (this).setPrivateKey(arg_0));
                    }
                }
            });
        }

        private Repository wagonRepository(RemoteRepository repository) {
            return new Repository(repository.getId(), repository.getUrl());
        }

        private RuleSet getRulesUsingWagon() throws MojoExecutionException {
            RulesUri uri;
            try {
                uri = RulesUri.build(this.rulesUri);
            }
            catch (URISyntaxException e) {
                this.log.warn((CharSequence)("Invalid rulesUri protocol: " + e.getMessage()));
                return null;
            }
            RemoteRepository repository = this.remoteRepository(uri);
            return Optional.ofNullable(this.wagonMap.get(repository.getProtocol())).map(wagon -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }).orElseThrow(() -> new MojoExecutionException("Could not load specified rules from " + this.rulesUri));
        }

        public static Optional<String> protocol(String url) {
            int pos = url.indexOf(":");
            return pos == -1 ? Optional.empty() : Optional.of(url.substring(0, pos).trim());
        }

        public Builder withRepositorySystem(RepositorySystem repositorySystem) {
            this.repositorySystem = repositorySystem;
            return this;
        }

        public Builder withIgnoredVersions(Collection<String> ignoredVersions) {
            this.ignoredVersions = ignoredVersions;
            return this;
        }

        public Builder withRuleSet(RuleSet ruleSet) {
            this.ruleSet = ruleSet;
            return this;
        }

        public Builder withServerId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder withRulesUri(String rulesUri) {
            this.rulesUri = rulesUri;
            return this;
        }

        public Builder withLog(Log log) {
            this.log = log;
            return this;
        }

        public Builder withMavenSession(MavenSession mavenSession) {
            this.mavenSession = mavenSession;
            return this;
        }

        public Builder withMojoExecution(MojoExecution mojoExecution) {
            this.mojoExecution = mojoExecution;
            return this;
        }

        public Builder withAetherRepositorySystem(org.eclipse.aether.RepositorySystem aetherRepositorySystem) {
            this.aetherRepositorySystem = aetherRepositorySystem;
            return this;
        }

        public Builder withWagonMap(Map<String, Wagon> wagonMap) {
            this.wagonMap = wagonMap;
            return this;
        }

        public DefaultVersionsHelper build() throws MojoExecutionException {
            DefaultVersionsHelper instance = new DefaultVersionsHelper(this.repositorySystem, this.aetherRepositorySystem, this.mavenSession, this.mojoExecution, this.log);
            if (this.ruleSet != null) {
                if (!Builder.isBlank(this.rulesUri)) {
                    this.log.warn((CharSequence)"rulesUri is ignored if rules are specified in pom or as parameters");
                }
                instance.ruleSet = this.ruleSet;
            } else {
                instance.ruleSet = Builder.isBlank(this.rulesUri) ? new RuleSet() : (DefaultVersionsHelper.isClasspathUri(this.rulesUri) ? Builder.getRulesFromClasspath(this.rulesUri, this.log) : this.getRulesUsingWagon());
            }
            if (this.ignoredVersions != null && !this.ignoredVersions.isEmpty()) {
                instance.ruleSet = Builder.enrichRuleSet(this.ignoredVersions, instance.ruleSet);
            }
            return instance;
        }

        private static boolean isBlank(String s) {
            return s == null || s.trim().isEmpty();
        }

        private static /* synthetic */ String lambda$getRulesUsingWagon$5(AuthenticationInfo ai) {
            return " as " + ai.getUserName();
        }

        private static /* synthetic */ String lambda$getRulesUsingWagon$4(ProxyInfo pi) {
            return " using proxy " + pi.getHost() + ":" + pi.getPort();
        }

        private static class RulesUri {
            String basePath;
            String resource;

            private RulesUri(String basePath, String resource) {
                this.basePath = basePath;
                this.resource = resource;
            }

            static RulesUri build(String rulesUri) throws URISyntaxException {
                int split = rulesUri.lastIndexOf(47);
                return split == -1 ? new RulesUri(rulesUri, "") : new RulesUri(rulesUri.substring(0, split) + '/', split + 1 < rulesUri.length() ? rulesUri.substring(split + 1) : "");
            }
        }
    }
}

