/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.UseLatestVersionsMojoBase;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="use-next-snapshots", threadSafe=true)
public class UseNextSnapshotsMojo
extends UseLatestVersionsMojoBase {
    @Parameter(property="allowMajorUpdates", defaultValue="false")
    private boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="false")
    private boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates;
    @Parameter(property="processDependencies", defaultValue="true")
    private boolean processDependencies = true;
    @Parameter(property="processDependencyManagement", defaultValue="true")
    private boolean processDependencyManagement = true;
    @Parameter(property="processParent", defaultValue="false")
    private boolean processParent = false;

    @Inject
    public UseNextSnapshotsMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected boolean getProcessDependencies() {
        return this.processDependencies;
    }

    @Override
    protected boolean getProcessDependencyManagement() {
        return this.processDependencyManagement;
    }

    @Override
    public boolean getProcessParent() {
        return this.processParent;
    }

    @Override
    protected boolean getAllowMajorUpdates() {
        return this.allowMajorUpdates;
    }

    @Override
    protected boolean getAllowMinorUpdates() {
        return this.allowMinorUpdates;
    }

    @Override
    protected boolean getAllowIncrementalUpdates() {
        return this.allowIncrementalUpdates;
    }

    @Override
    protected boolean getAllowSnapshots() {
        return true;
    }

    @Override
    protected boolean getAllowDowngrade() {
        return false;
    }

    @Override
    protected boolean updateFilter(Dependency dep) {
        return !ArtifactUtils.isSnapshot((String)dep.getVersion());
    }

    @Override
    protected boolean artifactVersionsFilter(ArtifactVersion ver) {
        return ArtifactUtils.isSnapshot((String)ver.toString());
    }

    @Override
    protected Optional<ArtifactVersion> versionProducer(Stream<ArtifactVersion> stream) {
        return stream.findFirst();
    }
}

