/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.selenium;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:selenium-maven-plugin:2.3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Selenium Plugin", 0);
        this.append(sb, "Support for using Selenium with Maven 2/3.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "selenium:help", 0);
            this.append(sb, "Display help information on selenium-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0selenium:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "selenese".equals(this.goal)) {
            this.append(sb, "selenium:selenese", 0);
            this.append(sb, "Run a suite of HTML Selenese tests.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "browser", 2);
                this.append(sb, "The browser name to run; must be one of the standard valid browser names (and must start with a *), e.g. *firefox, *iexplore, *custom.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "multiWindow (Default: false)", 2);
                this.append(sb, "True if the application under test should run in its own window, false if the AUT will run in an embedded iframe.", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 4444)", 2);
                this.append(sb, "The port on which we'll run the Selenium Server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "results", 2);
                this.append(sb, "The file to which we'll write out our test results.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Allows the tests to be skipped.", 3);
                this.append(sb, "Expression: ${maven.test.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "slowResources (Default: false)", 2);
                this.append(sb, "A debugging tool that slows down the Selenium Server. (Selenium developers only)", 3);
                this.append(sb, "", 0);
                this.append(sb, "startURL", 2);
                this.append(sb, "The base URL on which the tests will be run, e.g. http://www.google.com. Note that only the hostname part of this URL will really be used.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "suite", 2);
                this.append(sb, "The suite file to run.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeoutInSeconds (Default: 1800)", 2);
                this.append(sb, "Amount of time to wait before we just kill the browser.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "start-server".equals(this.goal)) {
            this.append(sb, "selenium:start-server", 0);
            this.append(sb, "Start the Selenium server.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "avoidProxy (Default: false)", 2);
                this.append(sb, "By default, we proxy every browser request; set this flag to make the browser use our proxy only for URLs containing '/selenium-server'", 3);
                this.append(sb, "Expression: ${avoidProxy}", 3);
                this.append(sb, "", 0);
                this.append(sb, "background (Default: false)", 2);
                this.append(sb, "Flag to control if we background the server or block Maven execution.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${background}", 3);
                this.append(sb, "", 0);
                this.append(sb, "browserSessionReuse (Default: false)", 2);
                this.append(sb, "Stops re-initialization and spawning of the browser between tests.", 3);
                this.append(sb, "Expression: ${browserSessionReuse}", 3);
                this.append(sb, "", 0);
                this.append(sb, "browserSideLog", 2);
                this.append(sb, "Enables logging on the browser side; logging messages will be transmitted to the server. This can affect performance.", 3);
                this.append(sb, "Expression: ${browserSideLog}", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Enable the server's debug mode..", 3);
                this.append(sb, "Expression: ${debug}", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultUserExtensions (Default: org/codehaus/mojo/selenium/default-user-extensions.js)", 2);
                this.append(sb, "The file or resource to use for default user-extensions.js.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultUserExtensionsEnabled (Default: true)", 2);
                this.append(sb, "Enable or disable default user-extensions.js", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayPropertiesFile (Default: ${project.build.directory}/selenium/display.properties)", 2);
                this.append(sb, "The location of the file to read the display properties.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ensureCleanSession (Default: false)", 2);
                this.append(sb, "If the browser does not have user profiles, make sure every new session has no artifacts from previous sessions. For example, enabling this option will cause all user cookies to be archived before launching IE, and restored after IE is closed.", 3);
                this.append(sb, "Expression: ${ensureCleanSession}", 3);
                this.append(sb, "", 0);
                this.append(sb, "firefoxProfileTemplate", 2);
                this.append(sb, "Normally a fresh empty Firefox profile is created every time we launch. You can specify a directory to make us copy your profile directory instead.", 3);
                this.append(sb, "Expression: ${firefoxProfileTemplate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "forcedBrowserMode", 2);
                this.append(sb, "Sets the browser mode (e.g. '*iexplore' for all sessions).", 3);
                this.append(sb, "Expression: ${forcedBrowserMode}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile (Default: ${project.build.directory}/selenium/server.log)", 2);
                this.append(sb, "The file that Selenium server logs will be written to.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${logFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logOutput (Default: false)", 2);
                this.append(sb, "Enable logging mode.", 3);
                this.append(sb, "Expression: ${logOutput}", 3);
                this.append(sb, "", 0);
                this.append(sb, "nonProxyHosts", 2);
                this.append(sb, "Configure the Selenium Server to use http.nonProxyHosts.", 3);
                this.append(sb, "Expression: ${nonProxyHosts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 4444)", 2);
                this.append(sb, "The port number of the server to connect to.", 3);
                this.append(sb, "Expression: ${port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "profilesLocation", 2);
                this.append(sb, "Specify the option profilesLocation to selenium. See selenium documentation", 3);
                this.append(sb, "Expression: ${profilesLocation}", 3);
                this.append(sb, "", 0);
                this.append(sb, "proxyHost", 2);
                this.append(sb, "Configure the Selenium Server to use http.proxyHost.", 3);
                this.append(sb, "Expression: ${proxyHost}", 3);
                this.append(sb, "", 0);
                this.append(sb, "proxyPort", 2);
                this.append(sb, "Configure the Selenium Server to use http.proxyPort.", 3);
                this.append(sb, "Expression: ${proxyPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "singleWindow (Default: false)", 2);
                this.append(sb, "Puts you into a mode where the test web site executes in a frame. This mode should only be selected if the application under test does not use frames.", 3);
                this.append(sb, "Expression: ${singleWindow}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Allows the server startup to be skipped.", 3);
                this.append(sb, "Expression: ${maven.test.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the selenium process.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: -1)", 2);
                this.append(sb, "Timeout for the server in seconds.", 3);
                this.append(sb, "Expression: ${timeout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "trustAllSSLCertificates (Default: false)", 2);
                this.append(sb, "Forces the Selenium proxy to trust all SSL certificates. This doesn't work in browsers that don't use the Selenium proxy.", 3);
                this.append(sb, "Expression: ${trustAllSSLCertificates}", 3);
                this.append(sb, "", 0);
                this.append(sb, "trustStore", 2);
                this.append(sb, "The location of the SSL trust-store.", 3);
                this.append(sb, "Expression: ${trustStore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "trustStorePassword", 2);
                this.append(sb, "The password for the SSL trust-store.", 3);
                this.append(sb, "Expression: ${trustStorePassword}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userExtensions", 2);
                this.append(sb, "Location of the user-extensions.js to load into the server. If defaultUserExtensionsEnabled is true, then this file will be appended to the defaults.", 3);
                this.append(sb, "Expression: ${userExtensions}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verifyBrowser", 2);
                this.append(sb, "Attempt to verify the named browser configuration. Must be one of the standard valid browser names (and must start with a *), e.g. *firefox, *iexplore, *custom.", 3);
                this.append(sb, "Expression: ${verifyBrowser}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory where Selenium server will be started from.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}/selenium", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stop-server".equals(this.goal)) {
            this.append(sb, "selenium:stop-server", 0);
            this.append(sb, "Stop the Selenium server.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 4444)", 2);
                this.append(sb, "The port number of the server to connect to.", 3);
                this.append(sb, "Expression: ${port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip goal execution", 3);
                this.append(sb, "Expression: ${maven.test.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "xvfb".equals(this.goal)) {
            this.append(sb, "selenium:xvfb", 0);
            this.append(sb, "Starts an Xvfb instance suitable for handling X11 displays for headless systems. Use this in combonation with the start-server goal to allow browsers to be launched on headless unix systems.\nOptionally uses 'xauth' to setup authentication for the Xvfb instance to allow running tests using the frame buffer server when another X server is already running.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "authenticationFile", 2);
                this.append(sb, "The file where X authentication data is stored for the Xvfb session. Default is to generate a temporary file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "background (Default: true)", 2);
                this.append(sb, "Flag to control if we background the process or block Maven execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "display", 2);
                this.append(sb, "The X11 display to use. Default value is :20.", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayPropertiesFile (Default: ${project.build.directory}/selenium/display.properties)", 2);
                this.append(sb, "The location of the file to write the display properties which will be picked up by the start-server goal.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile (Default: ${project.build.directory}/selenium/xvfb.log)", 2);
                this.append(sb, "The file that Xvfb output will be written to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logOutput (Default: true)", 2);
                this.append(sb, "Enable logging mode.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "A list of additional options to pass to the Xvfb process.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reuse (Default: false)", 2);
                this.append(sb, "Reuse Xvfb process", 3);
                this.append(sb, "Expression: ${xvfb.reuse}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip goal execution", 3);
                this.append(sb, "Expression: ${maven.test.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "xauthEnabled (Default: true)", 2);
                this.append(sb, "Use 'xauth' to setup permissions for the Xvfb server. This requires 'xauth' be installed and may be required when an X server is already running.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xauthExecutable (Default: xauth)", 2);
                this.append(sb, "The 'xauth' command to execute.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xauthProtocol (Default: .)", 2);
                this.append(sb, "The 'xauth' protocol.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xvfbExecutable (Default: Xvfb)", 2);
                this.append(sb, "The 'Xvfb' command to execute.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

