/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog.scm.hg.command.changelog;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.codehaus.mojo.scmchangelog.scm.hg.command.changelog.HgChangeLogConsumer;

public class HgChangeLogCommand
extends AbstractChangeLogCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion, String datePattern) throws ScmException {
        String revisions = "-r" + startVersion.getName() + ':' + endVersion.getName();
        String[] cmd = new String[]{"log", "--verbose", revisions};
        ScmLogger logger = this.getLogger();
        HgChangeLogConsumer consumer = new HgChangeLogConsumer(logger, datePattern);
        ScmResult result = HgUtils.execute((HgConsumer)consumer, (ScmLogger)logger, (File)fileSet.getBasedir(), (String[])cmd);
        logger.debug(result.toString());
        List logEntries = consumer.getModifications();
        ArrayList<ChangeSet> inRangeAndValid = new ArrayList<ChangeSet>();
        Date startDate = new Date(0L);
        Date endDate = new Date();
        Iterator it = logEntries.iterator();
        while (it.hasNext()) {
            ChangeSet change = (ChangeSet)it.next();
            if (change.getFiles().size() <= 0) continue;
            inRangeAndValid.add(change);
        }
        ChangeLogSet changeLogSet = new ChangeLogSet(inRangeAndValid, startDate, endDate);
        return new ChangeLogScmResult(changeLogSet, result);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repository, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        String revisions = "-r " + branch.getName();
        String[] cmd = new String[]{"log", "--verbose", revisions};
        HgChangeLogConsumer consumer = new HgChangeLogConsumer(this.getLogger(), datePattern);
        ScmResult result = HgUtils.execute((HgConsumer)consumer, (ScmLogger)this.getLogger(), (File)fileSet.getBasedir(), (String[])cmd);
        List logEntries = consumer.getModifications();
        ArrayList<ChangeSet> inRangeAndValid = new ArrayList<ChangeSet>();
        startDate = startDate == null ? new Date(0L) : startDate;
        endDate = endDate == null ? new Date() : endDate;
        Iterator it = logEntries.iterator();
        while (it.hasNext()) {
            ChangeSet change = (ChangeSet)it.next();
            if (change.getFiles().size() <= 0 || change.getDate().before(startDate) || change.getDate().after(endDate)) continue;
            inRangeAndValid.add(change);
        }
        ChangeLogSet changeLogSet = new ChangeLogSet(inRangeAndValid, startDate, endDate);
        return new ChangeLogScmResult(changeLogSet, result);
    }
}

