/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog.scm.hg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.mojo.scmchangelog.changelog.Release;
import org.codehaus.mojo.scmchangelog.changelog.log.ScmLogEntry;
import org.codehaus.mojo.scmchangelog.changelog.log.grammar.GrammarEnum;
import org.codehaus.mojo.scmchangelog.scm.hg.HgTargetEnum;
import org.codehaus.mojo.scmchangelog.scm.hg.command.changelog.BetterChangeSet;
import org.codehaus.mojo.scmchangelog.scm.util.ScmAdapter;
import org.codehaus.mojo.scmchangelog.scm.util.ScmTarget;
import org.codehaus.mojo.scmchangelog.tags.Tag;

public class HgScmAdapter
extends ScmAdapter {
    public HgScmAdapter(ScmManager currentManager, GrammarEnum currentGrammar) {
        super(currentManager, currentGrammar);
    }

    public List getListOfReleases(ScmRepository repository, ScmFileSet fileSet) throws ScmException, MojoExecutionException {
        ListScmResult result = this.manager.list(repository, fileSet, false, this.getScmVersion(HgTargetEnum.TAG, ""));
        List tags = result.getFiles();
        ArrayList<Release> releases = new ArrayList<Release>(10);
        Iterator iter = tags.iterator();
        String startRevision = "0";
        while (iter.hasNext()) {
            Tag tag = (Tag)iter.next();
            this.getLogger().info((CharSequence)tag.toString());
            ChangeLogScmResult logs = this.manager.changeLog(repository, fileSet, this.getScmVersion(HgTargetEnum.TRUNK, startRevision), this.getScmVersion(HgTargetEnum.TRUNK, tag.getEndRevision()), "");
            startRevision = tag.getEndRevision();
            this.getLogger().info((CharSequence)logs.getChangeLog().toString());
            tag.setDate(logs.getChangeLog().getEndDate());
            Release release = new Release(tag, this.getEntries(logs.getChangeLog().getChangeSets()));
            releases.add(release);
        }
        Collections.reverse(releases);
        return releases;
    }

    protected List getEntries(List changeSets) {
        ArrayList<ScmLogEntry> elements = new ArrayList<ScmLogEntry>(changeSets.size());
        Iterator iter = changeSets.iterator();
        while (iter.hasNext()) {
            BetterChangeSet changeSet = (BetterChangeSet)((Object)iter.next());
            ScmLogEntry entry = new ScmLogEntry();
            entry.setAuthor(changeSet.getAuthor());
            entry.setDate(changeSet.getDate());
            this.getLogger().info((CharSequence)changeSet.getComment());
            entry.setMessage(this.grammar.extractMessage(changeSet.getComment()));
            entry.setRevision(changeSet.getRevision());
            elements.add(entry);
        }
        return elements;
    }

    public ScmVersion getScmVersion(ScmTarget versionType, String version) throws MojoExecutionException {
        if (HgTargetEnum.TAG.equals(versionType)) {
            return new ScmTag(version);
        }
        if (HgTargetEnum.BRANCH.equals(versionType)) {
            return new ScmBranch(version);
        }
        if (HgTargetEnum.TRUNK.equals(versionType)) {
            return new ScmRevision(version);
        }
        throw new MojoExecutionException("Unknown version type : " + versionType);
    }
}

