/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.projectArchive.archive;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.mojo.projectArchive.archive.ProjectArchiver;
import org.codehaus.mojo.projectArchive.files.Fileset;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public class DefaultProjectArchiver
implements ProjectArchiver {
    private ArchiverManager archiverManager;

    public DefaultProjectArchiver() {
    }

    public DefaultProjectArchiver(ArchiverManager archiverManager) {
        this.archiverManager = archiverManager;
    }

    public void create(MavenProject project, File outputFile, String rootPath, List filesets, Log log) throws NoSuchArchiverException, ArchiverException, IOException {
        Archiver archiver = this.archiverManager.getArchiver(outputFile);
        archiver.setDestFile(outputFile);
        archiver.setIncludeEmptyDirs(true);
        FileSetManager fsManager = new FileSetManager(log);
        String root = rootPath;
        root = root == null ? "" : root.replace('\\', '/');
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        Iterator it = filesets.iterator();
        while (it.hasNext()) {
            Fileset fs = (Fileset)((Object)it.next());
            fs = fs.getInterpolatedCopy(project);
            File basedir = new File(fs.getDirectory());
            String[] includedFiles = fsManager.getIncludedFiles((FileSet)fs);
            String outputDirectory = fs.getOutputDirectory();
            if (outputDirectory != null) {
                if ((outputDirectory = outputDirectory.replace('\\', '/')).startsWith("/")) {
                    outputDirectory = outputDirectory.substring(1);
                }
                if (!outputDirectory.endsWith("/")) {
                    outputDirectory = outputDirectory + "/";
                }
            }
            for (int i = 0; i < includedFiles.length; ++i) {
                String relativePath = includedFiles[i];
                File file = new File(basedir, relativePath);
                if (outputDirectory != null) {
                    archiver.addFile(file, root + outputDirectory + relativePath);
                    continue;
                }
                archiver.addFile(file, root + relativePath);
            }
        }
        archiver.createArchive();
    }
}

