/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.javah.Javah;
import org.codehaus.mojo.natives.javah.JavahConfiguration;
import org.codehaus.mojo.natives.manager.JavahManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.plexus.util.FileUtils;

public class NativeJavahMojo
extends AbstractNativeMojo {
    private String javahProvider;
    private List classNames;
    private List javahClassNames = new ArrayList(0);
    private boolean javahSearchJNIFromDependencies;
    private File javahPath;
    protected File outputDirectory;
    protected File javahOutputDirectory;
    private String javahOutputFileName;
    private String outputFileName;
    private boolean javahVerbose;
    private JavahManager manager;
    private JavahConfiguration config;

    public void execute() throws MojoExecutionException {
        if (this.outputDirectory != null) {
            this.javahOutputDirectory = this.outputDirectory;
        }
        if (this.outputFileName != null) {
            this.javahOutputFileName = this.outputFileName;
        }
        if (this.classNames != null) {
            this.javahClassNames.addAll(this.classNames);
        }
        this.discoverAdditionalJNIClassName();
        if (this.javahClassNames.size() == 0) {
            return;
        }
        try {
            this.config = this.createProviderConfiguration();
            this.getJavah().compile(this.config);
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException("Error running javah command", (Exception)((Object)e));
        }
        this.project.addCompileSourceRoot(this.javahOutputDirectory.getAbsolutePath());
    }

    private Javah getJavah() throws MojoExecutionException {
        Javah javah;
        try {
            javah = this.manager.getJavah(this.javahProvider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return javah;
    }

    private List getJavahArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        List artifacts = this.project.getCompileArtifacts();
        if (artifacts != null) {
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                if (!"jar".equals(artifact.getType()) || "provided".equals(artifact.getScope())) continue;
                list.add(artifact);
            }
        }
        return list;
    }

    private String[] getJavahClassPath() {
        List artifacts = this.getJavahArtifacts();
        String[] classPaths = new String[artifacts.size() + 1];
        classPaths[0] = this.project.getBuild().getOutputDirectory();
        Iterator iter = artifacts.iterator();
        for (int i = 1; i < classPaths.length; ++i) {
            Artifact artifact = (Artifact)iter.next();
            classPaths[i] = artifact.getFile().getPath();
        }
        return classPaths;
    }

    private void discoverAdditionalJNIClassName() throws MojoExecutionException {
        if (!this.javahSearchJNIFromDependencies) {
            return;
        }
        List artifacts = this.getJavahArtifacts();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            this.getLog().info((CharSequence)("Parsing " + artifact.getFile() + " for native classes."));
            try {
                Enumeration<? extends ZipEntry> zipEntries = new ZipFile(artifact.getFile()).entries();
                block3: while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    if (!"class".equals(FileUtils.extension((String)zipEntry.getName()))) continue;
                    ClassParser parser = new ClassParser(artifact.getFile().getPath(), zipEntry.getName());
                    JavaClass clazz = parser.parse();
                    Method[] methods = clazz.getMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        if (!methods[j].isNative()) continue;
                        this.javahClassNames.add(clazz.getClassName());
                        this.getLog().info((CharSequence)("Found native class: " + clazz.getClassName()));
                        continue block3;
                    }
                }
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Error searching for native class in " + artifact.getFile(), (Exception)ioe);
            }
        }
    }

    private JavahConfiguration createProviderConfiguration() throws MojoExecutionException {
        JavahConfiguration config = new JavahConfiguration();
        config.setWorkingDirectory(this.workingDirectory);
        config.setVerbose(this.javahVerbose);
        config.setOutputDirectory(this.javahOutputDirectory);
        config.setFileName(this.javahOutputFileName);
        config.setClassPaths(this.getJavahClassPath());
        config.setClassNames(this.javahClassNames.toArray(new String[this.javahClassNames.size()]));
        config.setJavahPath(this.javahPath);
        return config;
    }

    protected JavahConfiguration getJavahConfiguration() {
        return this.config;
    }

    protected MavenProject getProject() {
        return this.project;
    }
}

