/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header.transformer;

import org.codehaus.mojo.license.header.transformer.AbstractFileHeaderTransformer;

public class PropertiesFileHeaderTransformer
extends AbstractFileHeaderTransformer {
    protected final String linesep = System.getProperty("line.separator");

    public PropertiesFileHeaderTransformer() {
        super("properties", "header transformer with properties file comment style", "###", "###", "# ");
    }

    public String[] getDefaultAcceptedExtensions() {
        return new String[]{"properties", "sh", "py", "rb", "pl", "pm"};
    }

    public String addHeader(String header, String content) {
        String result;
        int endProlog;
        String prolog = null;
        int startProlog = content.indexOf("#!");
        if (startProlog > -1 && (endProlog = content.indexOf(this.linesep)) > -1) {
            prolog = content.substring(0, endProlog + this.linesep.length());
        }
        if (prolog == null) {
            result = super.addHeader(header, content);
        } else {
            content = content.substring(prolog.length());
            result = super.addHeader(prolog + '\n' + header, content);
        }
        return result;
    }
}

