/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javancss;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.javancss.ModuleReport;
import org.codehaus.mojo.javancss.NcssAggregateReportGenerator;
import org.codehaus.mojo.javancss.NcssExecuter;
import org.codehaus.mojo.javancss.NcssReportGenerator;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

@Mojo(name="report")
public class NcssReportMojo
extends AbstractMavenReport {
    private static final String OUTPUT_NAME = "javancss";
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File xmlOutputDirectory;
    @Parameter(defaultValue="${project.build.sourceDirectory}", readonly=true, required=true)
    private File sourceDirectory;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String sourceEncoding;
    @Parameter(defaultValue="30")
    private int lineThreshold;
    @Parameter(defaultValue="javancss-raw-report.xml")
    private String tempFileName;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="linkXRef", defaultValue="true")
    private boolean linkXRef;
    @Parameter(defaultValue="${project.build.directory}/site/xref")
    private File xrefLocation;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(property="ncss.skip", defaultValue="false")
    private boolean skip;

    protected String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        if (!this.canGenerateReport()) {
            return;
        }
        if (this.canGenerateSingleReport()) {
            this.generateSingleReport(locale);
        }
        if (this.canGenerateAggregateReport()) {
            this.generateAggregateReport(locale);
        }
    }

    private void generateAggregateReport(Locale locale) throws MavenReportException {
        String basedir = this.project.getBasedir().toString();
        String output = this.xmlOutputDirectory.toString();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("basedir: " + basedir));
            this.getLog().debug((CharSequence)("output: " + output));
        }
        String relative = null;
        if (!output.startsWith(basedir)) {
            this.getLog().error((CharSequence)"Unable to aggregate report because I can't determine the relative location of the XML report");
            return;
        }
        relative = output.substring(basedir.length() + 1);
        this.getLog().debug((CharSequence)("relative: " + relative));
        ArrayList<ModuleReport> reports = new ArrayList<ModuleReport>();
        for (MavenProject child : this.reactorProjects) {
            File xmlReport = new File(child.getBasedir() + File.separator + relative, this.tempFileName);
            if (xmlReport.exists()) {
                reports.add(new ModuleReport(child, this.loadDocument(xmlReport)));
                continue;
            }
            this.getLog().debug((CharSequence)("xml file not found: " + xmlReport));
        }
        this.getLog().debug((CharSequence)("Aggregating " + reports.size() + " JavaNCSS reports"));
        NcssAggregateReportGenerator reportGenerator = new NcssAggregateReportGenerator(this.getSink(), NcssReportMojo.getBundle(locale), this.getLog());
        reportGenerator.doReport(locale, reports, this.lineThreshold);
    }

    private boolean isIncludeExcludeUsed() {
        return this.excludes != null || this.includes != null;
    }

    private void generateSingleReport(Locale locale) throws MavenReportException {
        this.getLog().info((CharSequence)("Running JavaNCSS " + NcssExecuter.getJavaNCSSVersion()));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Calling NcssExecuter with src: " + this.sourceDirectory));
            this.getLog().debug((CharSequence)("                       output: " + this.buildOutputFileName()));
            this.getLog().debug((CharSequence)("                     includes: " + this.includes));
            this.getLog().debug((CharSequence)("                     excludes: " + this.excludes));
            this.getLog().debug((CharSequence)("                     encoding: " + this.getSourceEncoding()));
        }
        NcssExecuter ncssExecuter = this.isIncludeExcludeUsed() ? new NcssExecuter(this.scanForSources(), this.buildOutputFileName()) : new NcssExecuter(this.sourceDirectory, this.buildOutputFileName());
        ncssExecuter.setEncoding(this.getSourceEncoding());
        ncssExecuter.execute();
        if (!this.isTempReportGenerated()) {
            throw new MavenReportException("Can't process temp ncss xml file.");
        }
        NcssReportGenerator reportGenerator = new NcssReportGenerator(this.getSink(), NcssReportMojo.getBundle(locale), this.getLog(), this.constructXRefLocation());
        reportGenerator.doReport(this.loadDocument(), this.lineThreshold);
    }

    private Document loadDocument(File file) throws MavenReportException {
        try {
            SAXReader saxReader = new SAXReader();
            return saxReader.read((Reader)ReaderFactory.newXmlReader((File)file));
        }
        catch (DocumentException de) {
            throw new MavenReportException(de.getMessage(), (Exception)((Object)de));
        }
        catch (IOException ioe) {
            throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
        }
    }

    private Document loadDocument() throws MavenReportException {
        return this.loadDocument(new File(this.buildOutputFileName()));
    }

    private boolean isTempReportGenerated() {
        return new File(this.buildOutputFileName()).exists();
    }

    public boolean canGenerateReport() {
        return !this.skip && (this.canGenerateSingleReport() || this.canGenerateAggregateReport());
    }

    private boolean canGenerateAggregateReport() {
        if (this.project.getModules().size() == 0) {
            return false;
        }
        if (this.sourceDirectory != null && this.sourceDirectory.exists()) {
            String[] sources = this.scanForSources();
            return sources == null || sources.length <= 0;
        }
        return true;
    }

    private boolean canGenerateSingleReport() {
        if (this.sourceDirectory == null || !this.sourceDirectory.exists()) {
            return false;
        }
        String[] sources = this.scanForSources();
        return sources != null && sources.length > 0;
    }

    private String[] scanForSources() {
        String[] defaultIncludes = new String[]{"**\\*.java"};
        DirectoryScanner ds = new DirectoryScanner();
        if (this.includes == null) {
            ds.setIncludes(defaultIncludes);
        } else {
            ds.setIncludes(this.includes);
        }
        if (this.excludes != null) {
            ds.setExcludes(this.excludes);
        }
        ds.setBasedir(this.sourceDirectory);
        this.getLog().debug((CharSequence)("Scanning base directory " + this.sourceDirectory));
        ds.scan();
        int maxFiles = ds.getIncludedFiles().length;
        String[] result = new String[maxFiles];
        for (int i = 0; i < maxFiles; ++i) {
            result[i] = this.sourceDirectory + File.separator + ds.getIncludedFiles()[i];
        }
        return result;
    }

    String buildOutputFileName() {
        return this.getXmlOutputDirectory() + File.separator + this.tempFileName;
    }

    public String getName(Locale locale) {
        return NcssReportMojo.getBundle(locale).getString("report.javancss.name");
    }

    public String getDescription(Locale locale) {
        return NcssReportMojo.getBundle(locale).getString("report.javancss.description");
    }

    protected String getXmlOutputDirectory() {
        return this.xmlOutputDirectory.getAbsolutePath();
    }

    public String getOutputName() {
        return OUTPUT_NAME;
    }

    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("javancss-report", locale, NcssReportMojo.class.getClassLoader());
    }

    protected String constructXRefLocation() {
        String location = null;
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.outputDirectory.getAbsolutePath(), (String)this.xrefLocation.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                location = relativePath;
            } else {
                for (ReportPlugin plugin : this.project.getReportPlugins()) {
                    String artifactId = plugin.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Source XRef to link to - DISABLED");
            }
        }
        return location;
    }
}

