/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javancss;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javancss.Javancss;
import org.apache.maven.reporting.MavenReportException;

public class NcssExecuter {
    private static final String DEFAULT_ERROR_MESSAGE = "Error while JavaNCSS was executing";
    private static final int ARG_SIZE = 8;
    private File sourceLocation;
    private String outputFilename;
    private String[] fileList;
    private String encoding = null;

    NcssExecuter() {
        this.sourceLocation = null;
        this.outputFilename = null;
        this.fileList = null;
    }

    public NcssExecuter(File sourceDirectory, String outputFilename) {
        this.sourceLocation = sourceDirectory;
        this.outputFilename = outputFilename;
        this.fileList = null;
    }

    public NcssExecuter(String[] fileList, String outputFilename) {
        this.sourceLocation = null;
        this.fileList = fileList;
        this.outputFilename = outputFilename;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void execute() throws MavenReportException {
        try {
            Javancss javancss = new Javancss(this.getCommandLineArgument());
            Throwable ncssException = javancss.getLastError();
            if (ncssException != null) {
                if (ncssException instanceof Exception) {
                    throw new MavenReportException(DEFAULT_ERROR_MESSAGE, (Exception)ncssException);
                }
                throw new MavenReportException(DEFAULT_ERROR_MESSAGE, new Exception(ncssException));
            }
        }
        catch (IOException ioe) {
            throw new MavenReportException("IO Error while running JavaNCSS", (Exception)ioe);
        }
    }

    private String[] getCommandLineArgument() {
        ArrayList<String> argumentList = new ArrayList<String>(8);
        argumentList.add("-package");
        argumentList.add("-object");
        argumentList.add("-function");
        argumentList.add("-xml");
        argumentList.add("-recursive");
        argumentList.add("-out");
        argumentList.add(this.outputFilename);
        if (this.encoding != null) {
            argumentList.add("-encoding");
            argumentList.add(this.encoding);
        }
        if (this.sourceLocation != null && this.sourceLocation.isDirectory()) {
            argumentList.add(this.sourceLocation.getAbsolutePath());
        } else {
            for (int i = 0; i < this.fileList.length; ++i) {
                argumentList.add(this.fileList[i]);
            }
        }
        return argumentList.toArray(new String[argumentList.size()]);
    }
}

