/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.hibernate3.util;

import java.util.List;
import java.util.Vector;
import org.apache.maven.execution.MavenSession;
import org.codehaus.mojo.hibernate3.util.HibernateExpressionEvaluator;
import org.codehaus.mojo.hibernate3.util.PropertyUtils;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlexusConfigurationUtils {
    public static PlexusConfiguration parseHibernateTool(PlexusConfiguration hibernatetool, String goalName, ClassLoader classLoader, MavenSession session) throws PlexusConfigurationException {
        HibernateExpressionEvaluator evaluator = new HibernateExpressionEvaluator(session);
        PlexusConfiguration defaultConfiguration = PlexusConfigurationUtils.findConfiguration(hibernatetool, evaluator);
        Vector<PlexusConfiguration> goals = new Vector<PlexusConfiguration>();
        Vector<PlexusConfiguration> properties = new Vector<PlexusConfiguration>();
        for (PlexusConfiguration child : hibernatetool.getChildren()) {
            if ("goal".equals(PropertyUtils.getProperty(child.getName()))) {
                goals.add(child);
                continue;
            }
            if (PlexusConfigurationUtils.isConfiguration(child)) continue;
            properties.add(child);
        }
        PlexusConfiguration target = PlexusConfigurationUtils.getTarget("hibernatetool", classLoader);
        for (PlexusConfiguration originalGoal : goals) {
            if (!"run".equals(goalName) && !originalGoal.getName().equals(goalName)) continue;
            PlexusConfiguration task = PlexusConfigurationUtils.getHibernateTask(hibernatetool, evaluator);
            PlexusConfigurationUtils.setDestinationDirectory(task, originalGoal, target, session, evaluator);
            PlexusConfigurationUtils.setHibernateConfiguration(task, originalGoal, defaultConfiguration, evaluator);
            PlexusConfigurationUtils.setHibernateGoal(task, originalGoal, evaluator);
            PlexusConfigurationUtils.setHibernateProperties(task, properties, evaluator);
            target.addChild(task);
        }
        return target;
    }

    public static PlexusConfiguration parseInstrument(PlexusConfiguration instrument, ClassLoader classLoader, MavenSession session) throws PlexusConfigurationException {
        HibernateExpressionEvaluator evaluator = new HibernateExpressionEvaluator(session);
        PlexusConfiguration target = PlexusConfigurationUtils.getTarget("instrument", classLoader);
        PlexusConfiguration task = PlexusConfigurationUtils.getHibernateTask(instrument, evaluator);
        target.addChild(PlexusConfigurationUtils.copyChild(task.getName(), task, evaluator));
        return target;
    }

    private static PlexusConfiguration copyChild(String key, PlexusConfiguration from, HibernateExpressionEvaluator evaluator) throws PlexusConfigurationException {
        String[] requiredChildren;
        String attributeValue;
        String[] requiredAttributeNames;
        XmlPlexusConfiguration to = new XmlPlexusConfiguration(from.getName());
        for (String attributeName : requiredAttributeNames = PropertyUtils.getPropertyArray(key + ".attributes")) {
            String string = PropertyUtils.getProperty(key + "." + attributeName + ".default");
            attributeValue = evaluator.evaluateString(string);
            to.setAttribute(attributeName, attributeValue);
        }
        for (String attributeName : from.getAttributeNames()) {
            if ("implementation".equals(attributeName)) continue;
            String string = from.getAttribute(attributeName);
            attributeValue = evaluator.evaluateString(string);
            to.setAttribute(attributeName, attributeValue);
        }
        to.setValue(from.getValue());
        for (String string : requiredChildren = PropertyUtils.getPropertyArray(key + ".children")) {
            from.getChild(string);
        }
        for (String string : from.getChildren()) {
            to.addChild(PlexusConfigurationUtils.copyChild(key + "." + string.getName(), (PlexusConfiguration)string, evaluator));
        }
        return to;
    }

    private static PlexusConfiguration findConfiguration(PlexusConfiguration configuration, HibernateExpressionEvaluator evaluator) throws PlexusConfigurationException {
        for (PlexusConfiguration child : configuration.getChildren()) {
            String[] requiredAttributeNames;
            if (!PlexusConfigurationUtils.isConfiguration(child)) continue;
            String name = child.getName();
            XmlPlexusConfiguration newConfiguration = new XmlPlexusConfiguration(name);
            for (String string : requiredAttributeNames = PropertyUtils.getPropertyArray(name + ".attributes")) {
                String attributeValueKey = PropertyUtils.getProperty(name + "." + string + ".default");
                String attributeValue = evaluator.evaluateString(attributeValueKey);
                if (!FileUtils.fileExists((String)attributeValue)) continue;
                newConfiguration.setAttribute(string, attributeValue);
            }
            for (String string : child.getAttributeNames()) {
                String attributeValue = evaluator.evaluateString(child.getAttribute(string));
                newConfiguration.setAttribute(string, attributeValue);
            }
            for (String string : child.getChildren()) {
                newConfiguration.addChild((PlexusConfiguration)string);
            }
            return newConfiguration;
        }
        return null;
    }

    private static PlexusConfiguration getHibernateTask(PlexusConfiguration configuration, HibernateExpressionEvaluator evaluator) throws PlexusConfigurationException {
        String attributeValue;
        String[] requiredAttributeNames;
        String name = configuration.getName();
        XmlPlexusConfiguration task = new XmlPlexusConfiguration(name);
        for (String attributeName : requiredAttributeNames = PropertyUtils.getPropertyArray(name + ".attributes")) {
            attributeValue = PropertyUtils.getProperty(name + "." + attributeName + ".default");
            task.setAttribute(attributeName, evaluator.evaluateString(attributeValue));
        }
        for (String attributeName : configuration.getAttributeNames()) {
            if ("implementation".equals(attributeName)) continue;
            attributeValue = evaluator.evaluateString(configuration.getAttribute(attributeName));
            task.setAttribute(attributeName, attributeValue);
        }
        return task;
    }

    private static PlexusConfiguration getTarget(String taskName, ClassLoader classLoader) {
        String[] implementations;
        XmlPlexusConfiguration target = new XmlPlexusConfiguration("target");
        for (String implementation : implementations = PropertyUtils.getPropertyArray(taskName + ".implementations")) {
            try {
                String className = PropertyUtils.getProperty(taskName + "." + implementation + ".implementation");
                classLoader.loadClass(className);
                XmlPlexusConfiguration taskdef = new XmlPlexusConfiguration("taskdef");
                taskdef.setAttribute("name", taskName);
                taskdef.setAttribute("classname", className);
                target.addChild((PlexusConfiguration)taskdef);
                break;
            }
            catch (ClassNotFoundException e) {
            }
        }
        return target;
    }

    private static boolean isConfiguration(PlexusConfiguration configuration) {
        return "configuration".equals(PropertyUtils.getProperty(configuration.getName()));
    }

    private static void setDestinationDirectory(PlexusConfiguration task, PlexusConfiguration goal, PlexusConfiguration target, MavenSession session, HibernateExpressionEvaluator evaluator) throws PlexusConfigurationException {
        String destdir = goal.getAttribute("destdir");
        if (destdir == null) {
            destdir = task.getAttribute("destdir");
        }
        if (destdir == null) {
            destdir = PropertyUtils.getProperty(goal.getName() + ".destdir");
        }
        destdir = evaluator.evaluateString(destdir);
        if ("true".equals(PropertyUtils.getProperty(goal.getName() + ".addtosource"))) {
            session.getCurrentProject().addCompileSourceRoot(destdir);
        }
        XmlPlexusConfiguration mkdir = new XmlPlexusConfiguration("mkdir");
        mkdir.setAttribute("dir", destdir);
        target.addChild((PlexusConfiguration)mkdir);
        ((XmlPlexusConfiguration)task).setAttribute("destdir", destdir);
    }

    private static void setHibernateConfiguration(PlexusConfiguration task, PlexusConfiguration originalGoal, PlexusConfiguration defaultConfiguration, HibernateExpressionEvaluator evaluator) throws PlexusConfigurationException {
        PlexusConfiguration configuration = PlexusConfigurationUtils.findConfiguration(originalGoal, evaluator);
        if (configuration == null) {
            configuration = defaultConfiguration;
        }
        task.addChild(configuration);
    }

    private static void setHibernateGoal(PlexusConfiguration task, PlexusConfiguration originalGoal, HibernateExpressionEvaluator evaluator) throws PlexusConfigurationException {
        String attributeValue;
        String[] requiredAttributeNames;
        String goalName = originalGoal.getName();
        PlexusConfiguration goal = task.getChild(goalName);
        for (String string : requiredAttributeNames = PropertyUtils.getPropertyArray(goalName + ".attributes")) {
            attributeValue = evaluator.evaluateString(PropertyUtils.getProperty(goalName + "." + string + ".default"));
            ((XmlPlexusConfiguration)goal).setAttribute(string, attributeValue);
        }
        for (String string : originalGoal.getAttributeNames()) {
            if ("destdir".equals(string)) continue;
            attributeValue = evaluator.evaluateString(originalGoal.getAttribute(string));
            ((XmlPlexusConfiguration)goal).setAttribute(string, attributeValue);
        }
        for (String string : originalGoal.getChildren()) {
            if (PlexusConfigurationUtils.isConfiguration((PlexusConfiguration)string)) continue;
            goal.addChild((PlexusConfiguration)string);
        }
        ((XmlPlexusConfiguration)goal).setValue(originalGoal.getValue());
    }

    private static void setHibernateProperties(PlexusConfiguration task, List<PlexusConfiguration> properties, HibernateExpressionEvaluator evaluator) throws PlexusConfigurationException {
        for (PlexusConfiguration property : properties) {
            task.addChild(PlexusConfigurationUtils.copyChild(property.getName(), property, evaluator));
        }
    }

    private PlexusConfigurationUtils() {
    }
}

