/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fit;

import fit.Fixture;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.fit.FixtureClassLoaderEnabled;

public class FixtureClassLoader
extends URLClassLoader {
    public FixtureClassLoader() {
        this(new URL[0]);
    }

    public FixtureClassLoader(List classpathElements) throws MalformedURLException {
        this(FixtureClassLoader.toClasspathURLs(classpathElements));
    }

    public FixtureClassLoader(URL[] urls) {
        this(urls, Fixture.class.getClassLoader());
    }

    public FixtureClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public Fixture newFixture(String fixtureName) throws InstantiationException, IllegalAccessException {
        String fixtureNotFound = "The fixture " + fixtureName + " was not found.";
        try {
            Fixture fixture = (Fixture)this.loadClass(fixtureName).newInstance();
            if (fixture instanceof FixtureClassLoaderEnabled) {
                ((FixtureClassLoaderEnabled)fixture).enableClassLoader(this);
            }
            Thread.currentThread().setContextClassLoader(this);
            return fixture;
        }
        catch (ClassCastException e) {
            throw new RuntimeException(fixtureName + " is not a " + Fixture.class.getName(), e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(fixtureNotFound, e);
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException(fixtureNotFound, e);
        }
    }

    protected static URL[] toClasspathURLs(List classpathElements) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (classpathElements != null) {
            Iterator i = classpathElements.iterator();
            while (i.hasNext()) {
                String classpathElement = (String)i.next();
                urls.add(new File(classpathElement).toURL());
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

