/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:buildnumber-maven-plugin:1.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Build Number Maven Plugin", 0);
        this.append(sb, "This plugin is designed to give you a build number. So when you might make 100 builds of version 1.0-SNAPSHOT, you can differentiate between them all.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "create".equals(this.goal)) {
            this.append(sb, "buildnumber:create", 0);
            this.append(sb, "This mojo is designed to give you a build number. So when you might make 100 builds of version 1.0-SNAPSHOT, you can differentiate between them all. The build number is based on the revision number retrieved from scm. It only works with subversion, currently. This mojo can also check to make sure that you have checked everything into scm, before issuing the build number. That behaviour can be suppressed, and then the latest local build number is used. Build numbers are not reflected in your artifact's filename (automatically), but can be added to the metadata. You can access the build number in your pom with ${buildNumber}. You can also access ${timestamp} and the scm branch of the build (if applicable) in ${buildScmBranch}", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "buildNumberPropertiesFileLocation (Default: ${basedir}/buildNumber.properties)", 2);
                this.append(sb, "Properties file to be created when 'format' is not null and item has 'buildNumber'. See Usage for details", 3);
                this.append(sb, "", 0);
                this.append(sb, "buildNumberPropertyName (Default: buildNumber)", 2);
                this.append(sb, "You can rename the buildNumber property name to another property name if desired.", 3);
                this.append(sb, "Expression: ${maven.buildNumber.buildNumberPropertyName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "doCheck (Default: false)", 2);
                this.append(sb, "If this is made true, we check for modified files, and if there are any, we fail the build. Note that this used to be inverted (skipCheck), but needed to be changed to allow releases to work. This corresponds to 'svn status'.", 3);
                this.append(sb, "Expression: ${maven.buildNumber.doCheck}", 3);
                this.append(sb, "", 0);
                this.append(sb, "doUpdate (Default: false)", 2);
                this.append(sb, "", 3);
                this.append(sb, "Expression: ${maven.buildNumber.doUpdate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "format", 2);
                this.append(sb, "Specify a message as specified by java.text.MessageFormat. This triggers 'items' configuration to be read", 3);
                this.append(sb, "", 0);
                this.append(sb, "getRevisionOnlyOnce (Default: false)", 2);
                this.append(sb, "If set to true, will get the scm revision once for all modules of a multi-module project instead of fetching once for each module.", 3);
                this.append(sb, "", 0);
                this.append(sb, "items", 2);
                this.append(sb, "Specify the corresponding items for the format message, as specified by java.text.MessageFormat. Special item values are 'timestamp' and 'buildNumber/d*'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locale", 2);
                this.append(sb, "The locale used for date and time formatting. The locale name should be in the format defined in Locale.toString(). The default locale is the platform default returned by Locale.getDefault().", 3);
                this.append(sb, "Expression: ${maven.buildNumber.locale}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password that is used when connecting to the SCM system.", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "Selects alternative SCM provider implementations. Each map key denotes the original provider type as given in the SCM URL like 'cvs' or 'svn', the map value specifies the provider type of the desired implementation to use instead. In other words, this map configures a substitition mapping for SCM providers.", 3);
                this.append(sb, "", 0);
                this.append(sb, "revisionOnScmFailure", 2);
                this.append(sb, "Setting this value allows the build to continue even in the event of an SCM failure. The value set will be used as the revision string in the event of a failure to retrieve the revision it from the SCM.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmBranchPropertyName (Default: scmBranch)", 2);
                this.append(sb, "You can rename the buildScmBranch property name to another property name if desired.", 3);
                this.append(sb, "Expression: ${maven.buildNumber.scmBranchPropertyName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmDirectory (Default: ${basedir})", 2);
                this.append(sb, "Local directory to be used to issue SCM actions", 3);
                this.append(sb, "Expression: ${maven.buildNumber.scmDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampFormat", 2);
                this.append(sb, "Apply this java.text.MessageFormat to the timestamp only (as opposed to the format parameter).", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampPropertyName (Default: timestamp)", 2);
                this.append(sb, "You can rename the timestamp property name to another property name if desired.", 3);
                this.append(sb, "Expression: ${maven.buildNumber.timestampPropertyName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useLastCommittedRevision (Default: false)", 2);
                this.append(sb, "whether to retrieve the revision for the last commit, or the last revision of the repository.", 3);
                this.append(sb, "Expression: ${maven.buildNumber.useLastCommittedRevision}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The username that is used when connecting to the SCM system.", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "create-timestamp".equals(this.goal)) {
            this.append(sb, "buildnumber:create-timestamp", 0);
            this.append(sb, "This mojo is designed to give you a timestamp available through one or more properties. Only a single timestamp is created for each execution of the mojo. This timestamp can be format into one or more strings which are then saved to properties.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "timestampFormat", 2);
                this.append(sb, "Apply this java.text.SimpleDateFormat to the timestamp.", 3);
                this.append(sb, "Expression: ${maven.buildNumber.timestampFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampPropertyName (Default: timestamp)", 2);
                this.append(sb, "You can rename the timestamp property name to another property name if desired.", 3);
                this.append(sb, "Expression: ${maven.buildNumber.timestampPropertyName}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "buildnumber:help", 0);
            this.append(sb, "Display help information on buildnumber-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0buildnumber:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hgchangeset".equals(this.goal)) {
            this.append(sb, "buildnumber:hgchangeset", 0);
            this.append(sb, "Goal which sets project properties for changeSet and changeSetDate from the current Mercurial repository.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "scmDirectory (Default: ${basedir})", 2);
                this.append(sb, "Local directory to be used to issue SCM actions", 3);
                this.append(sb, "Expression: ${maven.changeSet.scmDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

