/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.apt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;

public final class LogUtils {
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERROR = 3;

    private LogUtils() {
    }

    public static void log(Log log, int level, File file) {
        LogUtils.log(log, level, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Log log, int level, File file, CharSequence prefix) {
        if (!LogUtils.isEnabled(log, level)) {
            return;
        }
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            LogUtils.log(log, level, reader, prefix);
        }
        catch (FileNotFoundException exception) {
            try {
                log.warn((CharSequence)"Error logging file", (Throwable)exception);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
            IOUtil.close((Reader)reader);
        }
        IOUtil.close((Reader)reader);
    }

    public static void log(Log log, int level, Reader reader) {
        LogUtils.log(log, level, reader, null);
    }

    public static void log(Log log, int level, Reader reader, CharSequence prefix) {
        if (!LogUtils.isEnabled(log, level)) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                LogUtils.log(log, level, line, prefix);
            }
        }
        catch (IOException exception) {
            log.warn((CharSequence)"Error logging reader", (Throwable)exception);
        }
    }

    public static void log(Log log, int level, Collection messages) {
        LogUtils.log(log, level, messages, null);
    }

    public static void log(Log log, int level, Collection messages, CharSequence prefix) {
        if (!LogUtils.isEnabled(log, level)) {
            return;
        }
        Iterator iterator = messages.iterator();
        while (iterator.hasNext()) {
            LogUtils.log(log, level, iterator.next(), prefix);
        }
    }

    public static void log(Log log, int level, Object message) {
        LogUtils.log(log, level, message, null);
    }

    public static void log(Log log, int level, Object message, CharSequence prefix) {
        CharSequence chars = message instanceof CharSequence ? (CharSequence)message : String.valueOf(message);
        LogUtils.log(log, level, chars, prefix);
    }

    public static void log(Log log, int level, CharSequence message) {
        if (level == 0) {
            log.debug(message);
        } else if (level == 1) {
            log.info(message);
        } else if (level == 2) {
            log.warn(message);
        } else if (level == 3) {
            log.error(message);
        } else {
            throw new IllegalArgumentException("Unknown log level: " + level);
        }
    }

    public static void log(Log log, int level, CharSequence message, CharSequence prefix) {
        LogUtils.log(log, level, LogUtils.format(message, prefix));
    }

    public static boolean isEnabled(Log log, int level) {
        boolean enabled;
        if (level == 0) {
            enabled = log.isDebugEnabled();
        } else if (level == 1) {
            enabled = log.isInfoEnabled();
        } else if (level == 2) {
            enabled = log.isWarnEnabled();
        } else if (level == 3) {
            enabled = log.isErrorEnabled();
        } else {
            throw new IllegalArgumentException("Unknown log level: " + level);
        }
        return enabled;
    }

    private static CharSequence format(CharSequence message, CharSequence prefix) {
        if (prefix == null || prefix.length() == 0) {
            return message;
        }
        return new StringBuffer(prefix).append(message).toString();
    }
}

