/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.stax;

import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.java.JavaFieldMetadata;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JConstructor;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.modello.plugin.stax.AbstractStaxGenerator;
import org.codehaus.modello.plugin.stax.DummyIdModelField;
import org.codehaus.modello.plugins.xml.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.XmlClassMetadata;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;
import org.codehaus.plexus.util.StringUtils;

public class StaxWriterGenerator
extends AbstractStaxGenerator {
    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateStaxWriter();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating StAX Writer.", (Throwable)ex);
        }
    }

    private void generateStaxWriter() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = this.isPackageWithVersion() ? objectModel.getDefaultPackageName(true, this.getGeneratedVersion()) : objectModel.getDefaultPackageName(false, null);
        packageName = packageName + ".io.stax";
        String marshallerName = this.getFileName("StaxWriter");
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, marshallerName);
        JClass jClass = new JClass(marshallerName);
        jClass.setPackageName(packageName);
        jClass.addImport("java.io.InputStream");
        jClass.addImport("java.io.IOException");
        jClass.addImport("java.io.Writer");
        jClass.addImport("java.io.StringWriter");
        jClass.addImport("java.text.DateFormat");
        jClass.addImport("java.util.Iterator");
        jClass.addImport("java.util.Locale");
        jClass.addImport("java.util.jar.Manifest");
        jClass.addImport("javax.xml.stream.*");
        jClass.addImport("javanet.staxutils.IndentingXMLStreamWriter");
        jClass.addImport("org.codehaus.plexus.util.xml.Xpp3Dom");
        this.addModelImports(jClass, null);
        jClass.addField(new JField(JType.Int, "curId"));
        jClass.addField(new JField(new JType("java.util.Map"), "idMap"));
        JConstructor constructor = new JConstructor(jClass);
        constructor.getSourceCode().add("idMap = new java.util.HashMap();");
        jClass.addConstructor(constructor);
        String root = objectModel.getRoot(this.getGeneratedVersion());
        ModelClass rootClass = objectModel.getClass(root, this.getGeneratedVersion());
        ModelClassMetadata metadata = (ModelClassMetadata)rootClass.getMetadata(ModelClassMetadata.ID);
        String rootElement = metadata == null || metadata.getTagName() == null ? StaxWriterGenerator.uncapitalise((String)root) : metadata.getTagName();
        JMethod marshall = new JMethod(null, "write");
        marshall.addParameter(new JParameter((JType)new JClass("Writer"), "writer"));
        String rootElementParameterName = StaxWriterGenerator.uncapitalise((String)root);
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addException(new JClass("java.io.IOException"));
        marshall.addException(new JClass("XMLStreamException"));
        JSourceCode sc = marshall.getSourceCode();
        sc.add("XMLOutputFactory factory = XMLOutputFactory.newInstance();");
        sc.add("boolean supportWindowsLineEndings = false;");
        sc.add("if ( factory.isPropertySupported( \"com.ctc.wstx.outputEscapeCr\" ) )");
        sc.add("{");
        sc.indent();
        sc.add("factory.setProperty( \"com.ctc.wstx.outputEscapeCr\", Boolean.FALSE );");
        sc.add("supportWindowsLineEndings = true;");
        sc.unindent();
        sc.add("}");
        sc.add("if ( factory.isPropertySupported( \"org.codehaus.stax2.automaticEmptyElements\" ) )");
        sc.add("{");
        sc.indent();
        sc.add("factory.setProperty( \"org.codehaus.stax2.automaticEmptyElements\", Boolean.FALSE );");
        sc.unindent();
        sc.add("}");
        sc.add("IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter( factory.createXMLStreamWriter( writer ) );");
        sc.add("if ( supportWindowsLineEndings )");
        sc.add("{");
        sc.indent();
        sc.add("serializer.setNewLine( serializer.getLineSeparator() );");
        sc.unindent();
        sc.add("}");
        sc.add("serializer.writeStartDocument( " + rootElementParameterName + ".getModelEncoding(), \"1.0\" );");
        sc.add("write" + root + "( " + rootElementParameterName + ", \"" + rootElement + "\", serializer );");
        sc.add("serializer.writeEndDocument();");
        jClass.addMethod(marshall);
        this.createWriteDomMethod(jClass);
        this.writeAllClasses(objectModel, jClass);
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private void writeAllClasses(Model objectModel, JClass jClass) throws ModelloException {
        Iterator i = objectModel.getClasses(this.getGeneratedVersion()).iterator();
        while (i.hasNext()) {
            ModelClass clazz = (ModelClass)i.next();
            this.writeClass(clazz, jClass);
        }
    }

    private void writeClass(ModelClass modelClass, JClass jClass) throws ModelloException {
        String fieldTagName;
        XmlFieldMetadata fieldMetadata;
        ModelField field;
        String className = modelClass.getName();
        String uncapClassName = StaxWriterGenerator.uncapitalise((String)className);
        JMethod marshall = new JMethod(null, "write" + className);
        marshall.addParameter(new JParameter((JType)new JClass(className), uncapClassName));
        marshall.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        marshall.addParameter(new JParameter((JType)new JClass("XMLStreamWriter"), "serializer"));
        marshall.addException(new JClass("java.io.IOException"));
        marshall.addException(new JClass("XMLStreamException"));
        marshall.getModifiers().makePrivate();
        JSourceCode sc = marshall.getSourceCode();
        sc.add("if ( " + uncapClassName + " != null )");
        sc.add("{");
        sc.indent();
        XmlClassMetadata metadata = (XmlClassMetadata)modelClass.getMetadata(XmlClassMetadata.ID);
        String namespace = null;
        if (metadata.getNamespace() != null) {
            namespace = StringUtils.replace((String)metadata.getNamespace(), (String)"${version}", (String)this.getGeneratedVersion().toString());
            sc.add("serializer.setDefaultNamespace( \"" + namespace + "\" );");
        }
        sc.add("serializer.writeStartElement( tagName );");
        if (namespace != null) {
            sc.add("serializer.writeDefaultNamespace( \"" + namespace + "\" );");
            if (metadata.getSchemaLocation() != null) {
                String url = StringUtils.replace((String)metadata.getSchemaLocation(), (String)"${version}", (String)this.getGeneratedVersion().toString());
                sc.add("serializer.setPrefix( \"xsi\", \"http://www.w3.org/2001/XMLSchema-instance\" );");
                sc.add("serializer.writeNamespace( \"xsi\", \"http://www.w3.org/2001/XMLSchema-instance\" );");
                sc.add("serializer.writeAttribute( \"http://www.w3.org/2001/XMLSchema-instance\", \"schemaLocation\", \"" + namespace + " " + url + "\" );");
            }
        }
        if (this.isAssociationPartToClass(modelClass) && modelClass.getIdentifierFields(this.getGeneratedVersion()).size() != 1) {
            StaxWriterGenerator.writeIdMapCheck(sc, uncapClassName, "modello.id");
        }
        Iterator i = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (i.hasNext()) {
            field = (ModelField)i.next();
            fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            fieldTagName = fieldMetadata.getTagName();
            if (fieldTagName == null) {
                fieldTagName = field.getName();
            }
            String type = field.getType();
            String value = this.getFieldValue(uncapClassName, field);
            if (!fieldMetadata.isAttribute()) continue;
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.indent();
            sc.add("serializer.writeAttribute( \"" + fieldTagName + "\", " + StaxWriterGenerator.getValue(field.getType(), value, fieldMetadata) + " );");
            sc.unindent();
            sc.add("}");
        }
        Iterator fieldIterator = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (fieldIterator.hasNext()) {
            String singularTagName;
            field = (ModelField)fieldIterator.next();
            fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            fieldTagName = fieldMetadata.getTagName();
            if (fieldTagName == null) {
                fieldTagName = field.getName();
            }
            if ((singularTagName = fieldMetadata.getAssociationTagName()) == null) {
                singularTagName = this.singular(fieldTagName);
            }
            boolean wrappedList = "wrapped".equals(fieldMetadata.getListStyle());
            String type = field.getType();
            String value = this.getFieldValue(uncapClassName, field);
            if (fieldMetadata.isAttribute()) continue;
            if (field instanceof ModelAssociation) {
                ModelAssociation association = (ModelAssociation)field;
                String associationName = association.getName();
                ModelField referenceIdentifierField = this.getReferenceIdentifierField(association);
                if ("1".equals(association.getMultiplicity())) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.indent();
                    if (referenceIdentifierField != null) {
                        sc.add("serializer.writeStartElement( \"" + fieldTagName + "\" );");
                        this.writeElementAttribute(sc, referenceIdentifierField, value);
                        sc.add("serializer.writeEndElement();");
                    } else {
                        sc.add("write" + association.getTo() + "( (" + association.getTo() + ") " + value + ", \"" + fieldTagName + "\", serializer );");
                    }
                    sc.unindent();
                    sc.add("}");
                    continue;
                }
                type = association.getType();
                String toType = association.getTo();
                if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.indent();
                    if (wrappedList) {
                        sc.add("serializer.writeStartElement( \"" + fieldTagName + "\" );");
                    }
                    sc.add("for ( Iterator iter = " + value + ".iterator(); iter.hasNext(); )");
                    sc.add("{");
                    sc.indent();
                    if (this.isClassInModel(association.getTo(), modelClass.getModel())) {
                        sc.add(toType + " o = (" + toType + ") iter.next();");
                        if (referenceIdentifierField != null) {
                            sc.add("serializer.writeStartElement( \"" + singularTagName + "\" );");
                            this.writeElementAttribute(sc, referenceIdentifierField, "o");
                            sc.add("serializer.writeEndElement();");
                        } else {
                            sc.add("write" + toType + "( o, \"" + singularTagName + "\", serializer );");
                        }
                    } else {
                        sc.add(toType + " " + this.singular(StaxWriterGenerator.uncapitalise((String)field.getName())) + " = (" + toType + ") iter.next();");
                        sc.add("serializer.writeStartElement( \"" + singularTagName + "\" );");
                        sc.add("serializer.writeCharacters( " + this.singular(StaxWriterGenerator.uncapitalise((String)field.getName())) + " );");
                        sc.add("serializer.writeEndElement();");
                    }
                    sc.unindent();
                    sc.add("}");
                    if (wrappedList) {
                        sc.add("serializer.writeEndElement();");
                    }
                    sc.unindent();
                    sc.add("}");
                    continue;
                }
                XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                sc.add(this.getValueChecker(type, value, field));
                sc.add("{");
                sc.indent();
                if (wrappedList) {
                    sc.add("serializer.writeStartElement( \"" + fieldTagName + "\" );");
                }
                sc.add("for ( Iterator iter = " + value + ".keySet().iterator(); iter.hasNext(); )");
                sc.add("{");
                sc.indent();
                sc.add("String key = (String) iter.next();");
                sc.add("String value = (String) " + value + ".get( key );");
                if ("explode".equals(xmlAssociationMetadata.getMapStyle())) {
                    sc.add("serializer.writeStartElement( \"" + this.singular(associationName) + "\" );");
                    sc.add("serializer.writeStartElement( \"key\" );");
                    sc.add("serializer.writeCharacters( key );");
                    sc.add("serializer.writeEndElement();");
                    sc.add("serializer.writeStartElement( \"value\" );");
                    sc.add("serializer.writeCharacters( value );");
                    sc.add("serializer.writeEndElement();");
                    sc.add("serializer.writeEndElement();");
                } else {
                    sc.add("serializer.writeStartElement( \"\" + key + \"\" );");
                    sc.add("serializer.writeCharacters( value );");
                    sc.add("serializer.writeEndElement();");
                }
                sc.unindent();
                sc.add("}");
                if (wrappedList) {
                    sc.add("serializer.writeEndElement();");
                }
                sc.unindent();
                sc.add("}");
                continue;
            }
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.indent();
            if ("DOM".equals(field.getType())) {
                sc.add("writeDom( (Xpp3Dom) " + value + ", serializer );");
            } else {
                sc.add("serializer.writeStartElement( \"" + fieldTagName + "\" );");
                sc.add("serializer.writeCharacters( " + StaxWriterGenerator.getValue(field.getType(), value, fieldMetadata) + " );");
                sc.add("serializer.writeEndElement();");
            }
            sc.unindent();
            sc.add("}");
        }
        sc.add("serializer.writeEndElement();");
        sc.unindent();
        sc.add("}");
        jClass.addMethod(marshall);
    }

    private void writeElementAttribute(JSourceCode sc, ModelField referenceIdentifierField, String value) {
        if (referenceIdentifierField instanceof DummyIdModelField) {
            StaxWriterGenerator.writeIdMapCheck(sc, value, referenceIdentifierField.getName());
        } else {
            String v = StaxWriterGenerator.getValue(referenceIdentifierField.getType(), this.getFieldValue(value, referenceIdentifierField), (XmlFieldMetadata)referenceIdentifierField.getMetadata(XmlFieldMetadata.ID));
            sc.add("serializer.writeAttribute( \"" + referenceIdentifierField.getName() + "\", " + v + " );");
        }
    }

    private static void writeIdMapCheck(JSourceCode sc, String value, String attributeName) {
        sc.add("if ( !idMap.containsKey( " + value + " ) )");
        sc.add("{");
        sc.indent();
        sc.add("++curId;");
        sc.add("String id = String.valueOf( curId );");
        sc.add("idMap.put( " + value + ", id );");
        sc.add("serializer.writeAttribute( \"" + attributeName + "\", id );");
        sc.unindent();
        sc.add("}");
        sc.add("else");
        sc.add("{");
        sc.indent();
        sc.add("serializer.writeAttribute( \"" + attributeName + "\", (String) idMap.get( " + value + " ) );");
        sc.unindent();
        sc.add("}");
    }

    private String getFieldValue(String uncapClassName, ModelField field) {
        JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
        return uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
    }

    private void createWriteDomMethod(JClass jClass) {
        JMethod method = new JMethod("writeDom");
        method.addParameter(new JParameter(new JType("Xpp3Dom"), "dom"));
        method.addParameter(new JParameter(new JType("XMLStreamWriter"), "serializer"));
        method.addException(new JClass("XMLStreamException"));
        JSourceCode sc = method.getSourceCode();
        sc.add("serializer.writeStartElement( dom.getName() );");
        sc.add("String[] attributeNames = dom.getAttributeNames();");
        sc.add("for ( int i = 0; i < attributeNames.length; i++ )");
        sc.add("{");
        sc.indent();
        sc.add("String attributeName = attributeNames[i];");
        sc.add("serializer.writeAttribute( attributeName, dom.getAttribute( attributeName ) );");
        sc.unindent();
        sc.add("}");
        sc.add("Xpp3Dom[] children = dom.getChildren();");
        sc.add("for ( int i = 0; i < children.length; i++ )");
        sc.add("{");
        sc.indent();
        sc.add("writeDom( children[i], serializer );");
        sc.unindent();
        sc.add("}");
        sc.add("String value = dom.getValue();");
        sc.add("if ( value != null )");
        sc.add("{");
        sc.indent();
        sc.add("serializer.writeCharacters( value );");
        sc.unindent();
        sc.add("}");
        sc.add("serializer.writeEndElement();");
        jClass.addMethod(method);
    }

    private String getValueChecker(String type, String value, ModelField field) {
        String retVal = "boolean".equals(type) || "double".equals(type) || "float".equals(type) || "int".equals(type) || "long".equals(type) || "short".equals(type) ? "if ( " + value + " != " + field.getDefaultValue() + " )" : ("char".equals(type) ? "if ( " + value + " != '" + field.getDefaultValue() + "' )" : ("java.util.List".equals(type) || "java.util.Set".equals(type) || "java.util.Map".equals(type) || "java.util.Properties".equals(type) ? "if ( " + value + " != null && " + value + ".size() > 0 )" : ("String".equals(type) && field.getDefaultValue() != null ? "if ( " + value + " != null && !" + value + ".equals( \"" + field.getDefaultValue() + "\" ) )" : ("Date".equals(type) && field.getDefaultValue() != null ? "if ( " + value + " != null && !" + value + ".equals( \"" + field.getDefaultValue() + "\" ) )" : "if ( " + value + " != null )"))));
        return retVal;
    }
}

