/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.exception.ResourceInterruptedException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.unpacker.AbstractPackResources;
import com.izforge.izpack.installer.web.WebRepositoryAccessor;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

public class GUIPackResources
extends AbstractPackResources {
    private static final Logger logger = Logger.getLogger(GUIPackResources.class.getName());

    public GUIPackResources(Resources resources, InstallData installData) {
        super(resources, installData);
    }

    @Override
    protected InputStream getWebPackStream(String name, String webDirURL) {
        InputStream result;
        InstallData installData = this.getInstallData();
        String baseName = installData.getInfo().getInstallerBase();
        File installerDir = new File(baseName).getParentFile();
        if (baseName.contains("/")) {
            baseName = baseName.substring(baseName.lastIndexOf(47));
        }
        String packFileName = baseName + ".pack-" + name + ".jar";
        String path = null;
        File packLocalFile = new File(installerDir, packFileName);
        if (packLocalFile.exists() && packLocalFile.canRead()) {
            logger.info("Found local pack " + packLocalFile.getAbsolutePath());
            try {
                path = "jar:" + packLocalFile.toURI().toURL() + "!/packs/pack-" + name;
            }
            catch (MalformedURLException exception) {
                throw new ResourceException("Malformed URL", (Throwable)exception);
            }
        }
        String packURL = webDirURL + "/" + baseName + ".pack-" + name.replace(" ", "%20") + ".jar";
        logger.info("Downloading remote pack " + packURL);
        String tempFolder = IoHelper.translatePath((String)(installData.getInfo().getUninstallerPath() + "/IzpackWebTemp"), (Variables)installData.getVariables());
        try {
            String tempFile = WebRepositoryAccessor.getCachedUrl(packURL, tempFolder);
            packLocalFile = new File(tempFile);
        }
        catch (InterruptedIOException exception) {
            throw new ResourceInterruptedException("Retrieval of " + webDirURL + " interrupted", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ResourceException("Failed to read " + webDirURL, (Throwable)exception);
        }
        path = "jar:" + packLocalFile.getPath() + "!/packs/pack-" + name;
        try {
            URL url = new URL(path);
            result = url.openStream();
        }
        catch (IOException exception) {
            throw new ResourceException("Failed to read pack", (Throwable)exception);
        }
        return result;
    }
}

