/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.jersey;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCInstantiatedComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCManagedComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCProxiedComponentProvider;
import com.sun.jersey.spi.spring.container.SpringComponentProviderFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import org.aopalliance.aop.Advice;
import org.codehaus.enunciate.modules.jersey.AdvisedResourceFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EnunciateSpringComponentProviderFactory
extends SpringComponentProviderFactory {
    private final Map<Class, AdvisedResourceFactory> resourceFactories = new HashMap<Class, AdvisedResourceFactory>();
    private List<Object> interceptors;

    public EnunciateSpringComponentProviderFactory(ResourceConfig rc, ServletContext servletContext) {
        super(rc, (ConfigurableApplicationContext)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext));
        WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext).getAutowireCapableBeanFactory().autowireBean((Object)this);
    }

    public IoCComponentProvider getComponentProvider(ComponentContext cc, final Class c) {
        final IoCComponentProvider componentProvider = super.getComponentProvider(cc, c);
        if (c.isAnnotationPresent(Path.class)) {
            if (componentProvider instanceof IoCManagedComponentProvider) {
                return new IoCManagedComponentProvider(){

                    public ComponentScope getScope() {
                        return ((IoCManagedComponentProvider)componentProvider).getScope();
                    }

                    public Object getInjectableInstance(Object o) {
                        return EnunciateSpringComponentProviderFactory.this.getInjectableInstance(o);
                    }

                    public Object getInstance() {
                        return EnunciateSpringComponentProviderFactory.this.getResourceFactory(c).createAdvisedResource(componentProvider.getInstance());
                    }
                };
            }
            if (componentProvider instanceof IoCInstantiatedComponentProvider) {
                return new IoCInstantiatedComponentProvider(){

                    public Object getInjectableInstance(Object o) {
                        return EnunciateSpringComponentProviderFactory.this.getInjectableInstance(o);
                    }

                    public Object getInstance() {
                        return EnunciateSpringComponentProviderFactory.this.getResourceFactory(c).createAdvisedResource(componentProvider.getInstance());
                    }
                };
            }
            return new IoCProxiedComponentProvider(){

                public Object proxy(Object o) {
                    return EnunciateSpringComponentProviderFactory.this.getResourceFactory(c).createAdvisedResource(o);
                }

                public Object getInstance() {
                    return null;
                }
            };
        }
        return componentProvider;
    }

    public <T> T getInjectableInstance(T instance) {
        while (AopUtils.isAopProxy(instance)) {
            Advised aopResource = (Advised)instance;
            try {
                instance = aopResource.getTargetSource().getTarget();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get target object from proxy.", e);
            }
        }
        return instance;
    }

    @Resource(name="service-bean-interceptors")
    public void setEnunciateInterceptors(List<Object> interceptors) {
        this.interceptors = interceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> AdvisedResourceFactory<T> getResourceFactory(Class<T> resourceClass) {
        AdvisedResourceFactory<T> factory;
        Map<Class, AdvisedResourceFactory> map = this.resourceFactories;
        synchronized (map) {
            factory = this.resourceFactories.get(resourceClass);
            if (factory == null) {
                factory = new AdvisedResourceFactory<T>(resourceClass);
                if (this.interceptors != null && !this.interceptors.isEmpty()) {
                    for (Object interceptor : this.interceptors) {
                        if (interceptor instanceof Advice) {
                            factory.addAdvice((Advice)interceptor);
                            continue;
                        }
                        if (!(interceptor instanceof Advisor)) continue;
                        factory.addAdvisor((Advisor)interceptor);
                    }
                }
                this.resourceFactories.put(resourceClass, factory);
            }
        }
        return factory;
    }
}

