/*
 * #%L
 * Pollen :: Vote Counting
 * 
 * $Id: Method.java 3122 2012-01-30 20:43:30Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-votecounting/src/main/java/org/chorem/pollen/votecounting/business/Method.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.business;

import java.util.List;

import org.chorem.pollen.votecounting.dto.ChoiceDTO;

/**
 * Méthode de dépouillement.
 *
 * @version $Id: Method.java 3122 2012-01-30 20:43:30Z tchemit $
 */
public interface Method {
    /**
     * Execute le dépouillement de l'ensemble des choix spécifiés.
     * 
     * @param choices l'ensemble des choix à dépouiller
     * @param groupCounting si le dépouillement doit être groupé
     */
    public void executeCounting(List<Choice> choices, boolean groupCounting);
    
    /**
     * Effectue des statistiques sur le <code>choice</code> specifié.
     * 
     * La fonction <code>executeCounting</code> doit avoir été
     * executée avant d'appeler cette fonction.
     * 
     * @param choices l'ensemble des choix du dépouillement
     * @param groupCounting si le dépouillement doit être groupé
     * @param choice le choix sur lequel effectuer des statistiques
     * @param choiceDTO le choix contenant les resultats statistiques
     */
    public void executeStats(List<Choice> choices, boolean groupCounting,
            Choice choice, ChoiceDTO choiceDTO);
}