package org.chorem.pollen.votecounting;

/*
 * #%L
 * Pollen :: VoteCounting (Api)
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Locale;

import static org.nuiton.i18n.I18n.l_;

/**
 * Base abstract implementation of a {@link VoteCounting}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.6
 */
public abstract class AbstractVoteCounting<S extends VoteCountingStrategy> implements VoteCounting<S> {

    /** Unique id of the vote counting type. */
    protected final int id;

    /** Type of strategy used to vote count. */
    protected final Class<S> strategyType;

    /** I18n key for name of this vote counting type. */
    protected final String i18nName;

    /** I18n Key for short help of this vote counting type. */
    protected final String i18nShortHelp;

    /** I18n Key for help of this vote counting type. */
    protected final String i18nHelp;

    protected AbstractVoteCounting(int id,
                                   Class<S> strategyType,
                                   String i18nName,
                                   String i18nShortHelp,
                                   String i18nHelp) {
        this.id = id;
        this.strategyType = strategyType;
        this.i18nName = i18nName;
        this.i18nShortHelp = i18nShortHelp;
        this.i18nHelp = i18nHelp;
    }

    @Override
    public final S newStrategy() {
        try {
            return strategyType.newInstance();
        } catch (Exception e) {
            throw new RuntimeException("Could not instanciate strategy", e);
        }
    }

    @Override
    public final String getName(Locale locale) {
        String result = l_(locale, i18nName);
        return result;
    }

    @Override
    public final String getShortHelp(Locale locale) {
        String voteName = l_(locale, i18nName);
        String voteHelp = l_(locale, i18nShortHelp);
        String result =
                l_(locale, "pollen.voteCountingType.help", voteName, voteHelp);
        return result;
    }

    @Override
    public final String getHelp(Locale locale) {
        String result = l_(locale, i18nHelp);
        return result;
    }

    @Override
    public final int getId() {
        return id;
    }
}
