/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.chorem.pollen.votecounting.model.GroupOfVoter;
import org.chorem.pollen.votecounting.model.SimpleVoter;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;
import org.chorem.pollen.votecounting.model.VoterBuilder;

public class GroupOfVoterBuilder
implements VoterBuilder {
    private Set<Voter> voters = Sets.newHashSet();
    private GroupOfVoter groupOfVoter;
    private Voter voter;

    @Override
    public Set<Voter> getVoters() {
        this.flush();
        return this.voters;
    }

    @Override
    public GroupOfVoterBuilder newVoter(String voterId, double weight) {
        Preconditions.checkState((this.groupOfVoter != null ? 1 : 0) != 0, (Object)"No groupOfVoter defined, use method newGroupVoter before");
        this.flushVoter();
        this.voter = SimpleVoter.newVoter(voterId, weight, null);
        return this;
    }

    @Override
    public GroupOfVoterBuilder addVoteForChoice(String choiceId, Double voteValue) {
        Preconditions.checkState((this.voter != null ? 1 : 0) != 0, (Object)"No voter defined, use method newVoter before this one");
        VoteForChoice voteForChoice = VoteForChoice.newVote(choiceId, voteValue);
        this.voter.addVoteForChoice(voteForChoice);
        return this;
    }

    public GroupOfVoterBuilder newGroupVoter(String voterId, double weight) {
        this.flush();
        this.groupOfVoter = GroupOfVoter.newVoter(voterId, weight, null);
        return this;
    }

    public void flushVoter() {
        if (this.voter != null) {
            this.groupOfVoter.addVoter(this.voter);
            this.voter = null;
        }
    }

    @Override
    public void flush() {
        if (this.groupOfVoter != null) {
            this.flushVoter();
            this.voters.add(this.groupOfVoter);
            this.groupOfVoter = null;
        }
    }

    public GroupOfVoter getRoot() {
        return (GroupOfVoter)this.getVoters().iterator().next();
    }
}

