/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.components;

import java.io.File;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.ui.base.ContextLink;
import org.chorem.pollen.ui.services.Configuration;

/**
 * ImageContextLink
 *
 * Created: 4 nov. 2009
 *
 * @author fdesbois
 * @version $Revision$
 *
 * Mise a jour: $Date$
 * par : $Author$
 */
public class ImageContextLink implements ContextLink {

    public static final String THUMB_PREFIX = "thumb_";

    @Inject
    private Configuration config;

    /**
     * Directory for files getting or saving from this context
     * (ie. subdirectory where images are uploaded, main directory is defined by contextPath)
     */
    @Parameter
    private String dir;

    /**
     * true for thumbnails images prefixed by {@link Configuration.IMG_DIR}
     */
    @Parameter
    private boolean thumb;

    @Override
    public String getContextPath() {
        return config.getProperty(Configuration.IMG_DIR);
    }

    @Override
    public File getFile(String filename) {
        return getFile(filename, thumb);
    }

    public File getFile(String filename, boolean thumb) {
        if (thumb) {
            filename = THUMB_PREFIX + filename;
        }
        return new File(getImageDir(), filename);
    }

    /**
     * Get the directory where are uploaded the images from the context.
     * @return a File corresponding to the image directory
     */
    public File getImageDir() {
        File result = null;
        if (dir != null && !dir.isEmpty()) {
           result = new File(getContextPath(), dir);
        } else {
            result = new File(getContextPath());
        }
        return result;
    }

}
