/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.user;

import org.apache.tapestry5.Field;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.PasswordField;
import org.apache.tapestry5.corelib.components.TextField;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.services.ServiceAuth;
import org.chorem.pollen.business.services.ServiceUser;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.ui.data.Lien;

@IncludeStylesheet(value={"context:css/account.css"})
public class Account {
    @SessionState
    @Property
    private UserDTO user;
    @Property
    private boolean userExists;
    @Property
    @Persist
    private UserDTO newUser;
    @Persist
    private String oldEmail;
    @Component
    private Zone myAccountZone;
    @Component
    private Form myAccountForm;
    @Component(id="password")
    private PasswordField passwordField;
    @Component(id="newPassword1")
    private PasswordField newPasswordField;
    @Component(id="email")
    private TextField emailField;
    @Property
    private String password;
    @Property
    private String newPassword1;
    @Property
    private String newPassword2;
    @Inject
    private Messages messages;
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    @Property
    private boolean modify = false;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceAuth serviceAuth;

    Object onSuccessFromMyAccountForm() {
        this.modify = true;
        if (!this.serviceAuth.isLoginRight(this.newUser.getLogin(), MD5.encode((String)this.password))) {
            this.myAccountForm.recordError((Field)this.passwordField, this.messages.get("badPassword"));
        }
        if (this.newPassword1 != null && !this.newPassword1.equals("") && !this.newPassword1.equals(this.newPassword2)) {
            this.myAccountForm.recordError((Field)this.newPasswordField, this.messages.get("passwords-dont-match"));
        }
        if (!this.oldEmail.equals(this.newUser.getEmail()) && this.serviceUser.isUserEmailExisting(this.newUser.getEmail())) {
            this.myAccountForm.recordError((Field)this.emailField, this.messages.get("emailAlreadyExists"));
        }
        if (!this.myAccountForm.getHasErrors() && this.serviceUser.updateUser(this.newUser)) {
            if (this.newPassword1 != null && !this.newPassword1.equals("")) {
                this.serviceUser.updatePasswordUser(this.newUser, MD5.encode((String)this.newPassword1));
            }
            this.modify = false;
        }
        return this.myAccountZone.getBody();
    }

    Object onActionFromModifyButton() {
        this.modify = true;
        return this.myAccountZone.getBody();
    }

    void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
        if (this.userExists) {
            this.newUser = this.user;
            this.oldEmail = this.user.getEmail();
        }
    }
}

