/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.poll;

import java.util.Date;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.data.PollAction;
import org.chorem.pollen.ui.pages.poll.CloseValidation;
import org.chorem.pollen.ui.pages.poll.ConfirmPoll;

public class ConfirmPoll {
    @Persist
    private PollDTO poll;
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    @Persist
    private String backPage;
    @Persist
    private PollAction pollAction;
    @InjectPage
    private CloseValidation closeValidation;
    @Inject
    private Messages messages;
    @Inject
    private ServicePoll servicePoll;

    public PollDTO getPoll() {
        return this.poll;
    }

    public void setPoll(PollDTO poll) {
        this.poll = poll;
    }

    public String getBackPage() {
        return this.backPage;
    }

    public void setBackPage(String backPage) {
        this.backPage = backPage;
    }

    public void setAction(PollAction pollAction) {
        this.pollAction = pollAction;
    }

    public Object onActionFromValidateButton() {
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollAction[this.pollAction.ordinal()]) {
            case 1: {
                return this.closePoll();
            }
            case 2: {
                return this.deletePoll();
            }
        }
        return this.backPage;
    }

    private Object closePoll() {
        for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
            choice.setValidate(true);
        }
        Date now = new Date();
        if (this.poll.getEndDate() == null || now.before(this.poll.getEndDate())) {
            this.poll.setEndDate(now);
        }
        this.poll.setClosed(true);
        this.servicePoll.updatePoll(this.poll);
        this.closeValidation.setPoll(this.poll);
        return this.closeValidation;
    }

    private Object deletePoll() {
        this.servicePoll.deletePoll(this.poll.getId());
        return this.backPage;
    }

    public String getConfirmMessage() {
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollAction[this.pollAction.ordinal()]) {
            case 1: {
                return this.messages.get("confirmClose");
            }
            case 2: {
                return this.messages.get("confirmDelete");
            }
        }
        return "";
    }

    void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
    }
}

