/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.admin;

import java.util.HashMap;
import java.util.List;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.business.PreventRuleManager;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.services.ServiceList;
import org.chorem.pollen.business.services.ServiceUser;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.ui.components.FeedBack;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.services.Configuration;
import org.chorem.pollen.ui.utils.PasswordGenerator;

@IncludeStylesheet(value={"context:css/usersAdmin.css"})
public class UsersAdmin {
    @Component(id="feedback")
    private FeedBack feedback;
    @SessionState
    private String siteURL;
    @SessionState
    @Property
    private UserDTO user;
    @Property
    private boolean userExists;
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    @Property
    @Persist
    private List<UserDTO> accounts;
    @Property
    private UserDTO account;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Inject
    private Configuration conf;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceList serviceList;

    public void onPrepareFromUsersForm() {
        if (this.accounts == null) {
            this.accounts = this.serviceUser.selectUsers(null);
        }
    }

    public Object onSuccessFromUsersForm() {
        for (UserDTO usr : this.accounts) {
            if (this.serviceUser.findUserById(usr.getId()) != null) {
                this.serviceUser.updateUser(usr);
                continue;
            }
            String password = PasswordGenerator.generate((int)8);
            if (this.serviceUser.createUser(usr, MD5.encode((String)password)) != null) {
                this.feedback.addInfo(this.messages.format("userCreated", new Object[]{usr.getLogin()}));
                this.sendMailNotification(usr, password);
                continue;
            }
            this.feedback.addError(this.messages.format("userNotCreated", new Object[]{usr.getLogin()}));
        }
        this.feedback.addInfo(this.messages.get("dataSaved"));
        this.resources.discardPersistentFieldChanges();
        return this;
    }

    Object onAddRowFromUsersLoop() {
        UserDTO usr = new UserDTO();
        usr.setId(String.valueOf(System.nanoTime()));
        this.accounts.add(usr);
        return usr;
    }

    void onRemoveRowFromUsersLoop(UserDTO usr) {
        if (this.serviceUser.findUserById(usr.getId()) != null) {
            this.serviceList.deletePersonLists(usr.getId());
            if (this.serviceUser.deleteUser(usr)) {
                this.accounts.remove(usr);
            }
        } else {
            this.accounts.remove(usr);
        }
    }

    public ValueEncoder<UserDTO> getUserEncoder() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void sendMailNotification(UserDTO newUser, String password) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("host", this.conf.getProperty("email_host"));
        data.put("port", this.conf.getProperty("email_port"));
        data.put("from", this.conf.getProperty("email_from"));
        data.put("to", newUser.getEmail());
        data.put("title", this.messages.format("registerEmail_subject", new Object[]{newUser.getLogin()}));
        data.put("msg", this.messages.format("registerEmail_msg", new Object[]{newUser.getFirstName(), newUser.getLastName(), newUser.getLogin(), password, this.siteURL}));
        PreventRuleManager.emailAction(data);
    }

    public boolean isMyAccount() {
        if (this.userExists) {
            return this.user.getId().equals(this.account.getId());
        }
        return false;
    }

    public void onActivate() {
        if (this.userExists && !this.user.isAdministrator()) {
            this.feedback.addError(this.messages.get("userNotAllowed"));
        }
    }

    public void setupRender() {
        this.accounts = this.serviceUser.selectUsers(null);
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
    }

    static /* synthetic */ List access$000(UsersAdmin x0) {
        return x0.accounts;
    }
}

